/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.config.customization.UtilitiesMethod;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientClass;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.specs.Ec2ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.JsonProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.QueryProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.XmlProtocolSpec;
import software.amazon.awssdk.codegen.poet.model.ServiceClientConfigurationUtils;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;

public class SyncClientClass
extends SyncClientInterface {
    private final IntermediateModel model;
    private final PoetExtension poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;
    private final ClassName serviceClientConfigurationClassName;
    private final ServiceClientConfigurationUtils configurationUtils;
    private final boolean useSraAuth;

    public SyncClientClass(GeneratorTaskParams taskParams) {
        super(taskParams.getModel());
        this.model = taskParams.getModel();
        this.poetExtensions = taskParams.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model);
        this.serviceClientConfigurationClassName = new PoetExtension(this.model).getServiceConfigClass();
        this.configurationUtils = new ServiceClientConfigurationUtils(this.model);
        this.useSraAuth = new AuthSchemeSpecUtils(this.model).useSraAuth();
    }

    @Override
    protected void addInterfaceClass(TypeSpec.Builder type) {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        type.addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass});
    }

    @Override
    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createClassBuilder(this.className);
    }

    @Override
    protected void addAnnotations(TypeSpec.Builder type) {
        type.addAnnotation(SdkInternalApi.class);
    }

    @Override
    protected void addModifiers(TypeSpec.Builder type) {
        type.addModifiers(new Modifier[]{Modifier.FINAL});
    }

    @Override
    protected void addFields(TypeSpec.Builder type) {
        type.addField(this.logger()).addField(SyncClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addField(SdkClientConfiguration.class, "clientConfiguration", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField((TypeName)this.serviceClientConfigurationClassName, "serviceClientConfiguration", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
    }

    @Override
    protected void addAdditionalMethods(TypeSpec.Builder type) {
        if (!this.useSraAuth && this.model.containsRequestSigners()) {
            type.addMethod(ClientClassUtils.applySignerOverrideMethod(this.poetExtensions, this.model));
        }
        this.model.getEndpointOperation().ifPresent(o -> type.addField(EndpointDiscoveryRefreshCache.class, "endpointDiscoveryCache", new Modifier[]{Modifier.PRIVATE}));
        type.addMethod(this.constructor()).addMethod(this.nameMethod()).addMethods(this.protocolSpec.additionalMethods()).addMethod(this.resolveMetricPublishersMethod());
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)type).addMethod(arg_0));
        type.addMethod(AsyncClientClass.updateSdkClientConfigurationMethod((TypeName)this.configurationUtils.serviceClientConfigurationBuilderClassName()));
        type.addMethod(this.protocolSpec.initProtocolFactory(this.model));
    }

    private FieldSpec logger() {
        return FieldSpec.builder(Logger.class, (String)"log", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.loggerFor($T.class)", new Object[]{Logger.class, this.className}).build();
    }

    private MethodSpec nameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return SERVICE_NAME", new Object[0]).build();
    }

    @Override
    protected MethodSpec serviceClientConfigMethod() {
        return MethodSpec.methodBuilder((String)"serviceClientConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)this.serviceClientConfigurationClassName).addStatement("return this.serviceClientConfiguration", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private MethodSpec constructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)this.serviceClientConfigurationClassName, "serviceClientConfiguration", new Modifier[0]).addParameter(SdkClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration)", new Object[]{this.protocolSpec.getClientHandlerClass()}).addStatement("this.clientConfiguration = clientConfiguration", new Object[0]).addStatement("this.serviceClientConfiguration = serviceClientConfiguration", new Object[0]);
        FieldSpec protocolFactoryField = this.protocolSpec.protocolFactory(this.model);
        if (this.model.getMetadata().isJsonProtocol()) {
            builder.addStatement("this.$N = init($T.builder()).build()", new Object[]{protocolFactoryField.name, protocolFactoryField.type});
        } else {
            builder.addStatement("this.$N = init()", new Object[]{protocolFactoryField.name});
        }
        if (this.model.getEndpointOperation().isPresent()) {
            builder.beginControlFlow("if (clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED))", new Object[0]);
            builder.addStatement("this.endpointDiscoveryCache = $T.create($T.create(this))", new Object[]{EndpointDiscoveryRefreshCache.class, this.poetExtensions.getClientClass(this.model.getNamingStrategy().getServiceName() + "EndpointDiscoveryCacheLoader")});
            if (this.model.getCustomizationConfig().allowEndpointOverrideForEndpointDiscoveryRequiredOperations()) {
                builder.beginControlFlow("if (clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE)", new Object[0]);
                builder.addStatement("log.warn(() -> $S)", new Object[]{"Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended."});
                builder.endControlFlow();
            }
            builder.endControlFlow();
        }
        return builder.build();
    }

    protected List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().filter(o -> !o.hasEventStreamInput()).filter(o -> !o.hasEventStreamOutput()).flatMap(this::operations).collect(Collectors.toList());
    }

    private Stream<MethodSpec> operations(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.traditionalMethod(opModel));
        return methods.stream();
    }

    private MethodSpec traditionalMethod(OperationModel opModel) {
        MethodSpec.Builder method = SyncClientInterface.operationMethodSignature(this.model, opModel).addAnnotation(Override.class);
        if (!this.useSraAuth) {
            method.addCode(ClientClassUtils.callApplySignerOverrideMethod(opModel));
        }
        method.addCode(this.protocolSpec.responseHandler(this.model, opModel));
        this.protocolSpec.errorResponseHandler(opModel).ifPresent(arg_0 -> ((MethodSpec.Builder)method).addCode(arg_0));
        if (opModel.getEndpointDiscovery() != null) {
            method.addStatement("boolean endpointDiscoveryEnabled = clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)", new Object[0]);
            method.addStatement("boolean endpointOverridden = clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE", new Object[0]);
            if (opModel.getEndpointDiscovery().isRequired()) {
                if (!this.model.getCustomizationConfig().allowEndpointOverrideForEndpointDiscoveryRequiredOperations()) {
                    method.beginControlFlow("if (endpointOverridden)", new Object[0]);
                    method.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery, but an endpoint override was specified when the client was created. This is not supported."});
                    method.endControlFlow();
                    method.beginControlFlow("if (!endpointDiscoveryEnabled)", new Object[0]);
                    method.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery, but endpoint discovery was disabled on the client."});
                    method.endControlFlow();
                } else {
                    method.beginControlFlow("if (endpointOverridden)", new Object[0]);
                    method.addStatement("endpointDiscoveryEnabled = false", new Object[0]);
                    method.nextControlFlow("else if (!endpointDiscoveryEnabled)", new Object[0]);
                    method.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created."});
                    method.endControlFlow();
                }
            }
            method.addStatement("$T cachedEndpoint = null", new Object[]{URI.class});
            method.beginControlFlow("if (endpointDiscoveryEnabled)", new Object[0]);
            ParameterizedTypeName identityFutureTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(AwsCredentialsIdentity.class)});
            method.addCode("$T identityFuture = $N.overrideConfiguration()", new Object[]{identityFutureTypeName, opModel.getInput().getVariableName()}).addCode("    .flatMap($T::credentialsIdentityProvider)", new Object[]{AwsRequestOverrideConfiguration.class}).addCode("    .orElseGet(() -> clientConfiguration.option($T.CREDENTIALS_IDENTITY_PROVIDER))", new Object[]{AwsClientOption.class}).addCode("    .resolveIdentity();", new Object[0]);
            method.addCode("$T key = $T.joinLikeSync(identityFuture).accessKeyId();", new Object[]{String.class, CompletableFutureUtils.class});
            method.addCode("$1T endpointDiscoveryRequest = $1T.builder()", new Object[]{EndpointDiscoveryRequest.class}).addCode("    .required($L)", new Object[]{opModel.getInputShape().getEndpointDiscovery().isRequired()}).addCode("    .defaultEndpoint(clientConfiguration.option($T.ENDPOINT))", new Object[]{SdkClientOption.class}).addCode("    .overrideConfiguration($N.overrideConfiguration().orElse(null))", new Object[]{opModel.getInput().getVariableName()}).addCode("    .build();", new Object[0]);
            method.addStatement("cachedEndpoint = endpointDiscoveryCache.get(key, endpointDiscoveryRequest)", new Object[0]);
            method.endControlFlow();
        }
        method.addStatement("$T clientConfiguration = updateSdkClientConfiguration($L, this.clientConfiguration)", new Object[]{SdkClientConfiguration.class, opModel.getInput().getVariableName()});
        method.addStatement("$T<$T> metricPublishers = resolveMetricPublishers(clientConfiguration, $N.overrideConfiguration().orElse(null))", new Object[]{List.class, MetricPublisher.class, opModel.getInput().getVariableName()}).addStatement("$1T apiCallMetricCollector = metricPublishers.isEmpty() ? $2T.create() : $1T.create($3S)", new Object[]{MetricCollector.class, NoOpMetricCollector.class, "ApiCall"});
        method.beginControlFlow("try", new Object[0]).addStatement("apiCallMetricCollector.reportMetric($T.$L, $S)", new Object[]{CoreMetric.class, "SERVICE_ID", this.model.getMetadata().getServiceId()}).addStatement("apiCallMetricCollector.reportMetric($T.$L, $S)", new Object[]{CoreMetric.class, "OPERATION_NAME", opModel.getOperationName()});
        ClientClassUtils.addS3ArnableFieldCode(opModel, this.model).ifPresent(arg_0 -> ((MethodSpec.Builder)method).addCode(arg_0));
        method.addCode(ClientClassUtils.addEndpointTraitCode(opModel));
        method.addCode(this.protocolSpec.executionHandler(opModel)).endControlFlow().beginControlFlow("finally", new Object[0]).addStatement("metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()))", new Object[0]).endControlFlow();
        return method.build();
    }

    @Override
    protected void addCloseMethod(TypeSpec.Builder type) {
        MethodSpec method = MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$N.close()", new Object[]{"clientHandler"}).build();
        type.addMethod(method);
    }

    @Override
    protected MethodSpec.Builder utilitiesOperationBody(MethodSpec.Builder builder) {
        UtilitiesMethod config = this.model.getCustomizationConfig().getUtilitiesMethod();
        String instanceClass = config.getInstanceType();
        if (instanceClass == null) {
            instanceClass = config.getReturnType();
        }
        ClassName instanceType = PoetUtils.classNameFromFqcn(instanceClass);
        return builder.addAnnotation(Override.class).addStatement("return $T.create($L)", new Object[]{instanceType, String.join((CharSequence)",", config.getCreateMethodParams())});
    }

    static ProtocolSpec getProtocolSpecs(PoetExtension poetExtensions, IntermediateModel model) {
        Protocol protocol = model.getMetadata().getProtocol();
        switch (protocol) {
            case QUERY: {
                return new QueryProtocolSpec(model, poetExtensions);
            }
            case REST_XML: {
                return new XmlProtocolSpec(model, poetExtensions);
            }
            case EC2: {
                return new Ec2ProtocolSpec(model, poetExtensions);
            }
            case AWS_JSON: 
            case REST_JSON: 
            case CBOR: {
                return new JsonProtocolSpec(poetExtensions, model);
            }
        }
        throw new RuntimeException("Unknown protocol: " + protocol.name());
    }

    private MethodSpec resolveMetricPublishersMethod() {
        String clientConfigName = "clientConfiguration";
        String requestOverrideConfigName = "requestOverrideConfiguration";
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"resolveMetricPublishers").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{MetricPublisher.class})).addParameter(SdkClientConfiguration.class, clientConfigName, new Modifier[0]).addParameter(RequestOverrideConfiguration.class, requestOverrideConfigName, new Modifier[0]);
        String publishersName = "publishers";
        methodBuilder.addStatement("$T $N = null", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{MetricPublisher.class}), publishersName});
        methodBuilder.beginControlFlow("if ($N != null)", new Object[]{requestOverrideConfigName}).addStatement("$N = $N.metricPublishers()", new Object[]{publishersName, requestOverrideConfigName}).endControlFlow();
        methodBuilder.beginControlFlow("if ($1N == null || $1N.isEmpty())", new Object[]{publishersName}).addStatement("$N = $N.option($T.$N)", new Object[]{publishersName, clientConfigName, SdkClientOption.class, "METRIC_PUBLISHERS"}).endControlFlow();
        methodBuilder.beginControlFlow("if ($1N == null)", new Object[]{publishersName}).addStatement("$N = $T.emptyList()", new Object[]{publishersName, Collections.class}).endControlFlow();
        methodBuilder.addStatement("return $N", new Object[]{publishersName});
        return methodBuilder.build();
    }

    @Override
    protected MethodSpec.Builder waiterOperationBody(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return $T.builder().client(this).build()", new Object[]{this.poetExtensions.getSyncWaiterInterface()});
    }
}

