/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform.protocols;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.transform.protocols.MarshallerProtocolSpec;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.utils.StringUtils;

public class QueryMarshallerSpec
implements MarshallerProtocolSpec {
    protected final ShapeModel shapeModel;
    private final Metadata metadata;

    public QueryMarshallerSpec(IntermediateModel model, ShapeModel shapeModel) {
        this.metadata = model.getMetadata();
        this.shapeModel = shapeModel;
    }

    @Override
    public ParameterSpec protocolFactoryParameter() {
        return ParameterSpec.builder(this.protocolFactoryClass(), (String)"protocolFactory", (Modifier[])new Modifier[0]).build();
    }

    protected Class<?> protocolFactoryClass() {
        return AwsQueryProtocolFactory.class;
    }

    @Override
    public CodeBlock marshalCodeBlock(ClassName requestClassName) {
        String variableName = this.shapeModel.getVariable().getVariableName();
        return CodeBlock.builder().addStatement("$T<$T> protocolMarshaller = protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING)", new Object[]{ProtocolMarshaller.class, SdkHttpFullRequest.class}).addStatement("return protocolMarshaller.marshall($L)", new Object[]{variableName}).build();
    }

    @Override
    public FieldSpec protocolFactory() {
        return FieldSpec.builder(this.protocolFactoryClass(), (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public Optional<MethodSpec> constructor() {
        return Optional.of(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.protocolFactoryParameter()).addStatement("this.protocolFactory = protocolFactory", new Object[0]).build());
    }

    @Override
    public List<FieldSpec> memberVariables() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        CodeBlock.Builder initializationCodeBlockBuilder = CodeBlock.builder().add("$T.builder()", new Object[]{OperationInfo.class});
        initializationCodeBlockBuilder.add(".requestUri($S)", new Object[]{this.shapeModel.getMarshaller().getRequestUri()}).add(".httpMethod($T.$L)", new Object[]{SdkHttpMethod.class, this.shapeModel.getMarshaller().getVerb()}).add(".hasExplicitPayloadMember($L)", new Object[]{this.shapeModel.isHasPayloadMember() || this.shapeModel.getExplicitEventPayloadMember() != null}).add(".hasPayloadMembers($L)", new Object[]{this.shapeModel.hasPayloadMembers()});
        if (StringUtils.isNotBlank((CharSequence)this.shapeModel.getMarshaller().getTarget())) {
            initializationCodeBlockBuilder.add(".operationIdentifier($S)", new Object[]{this.shapeModel.getMarshaller().getTarget()}).add(".apiVersion($S)", new Object[]{this.metadata.getApiVersion()});
        }
        if (this.shapeModel.isHasStreamingMember()) {
            initializationCodeBlockBuilder.add(".hasStreamingInput(true)", new Object[0]);
        }
        if (this.metadata.getProtocol() == Protocol.REST_XML) {
            String rootMarshallLocationName = this.shapeModel.getMarshaller() != null ? this.shapeModel.getMarshaller().getLocationName() : null;
            initializationCodeBlockBuilder.add(".putAdditionalMetadata($T.ROOT_MARSHALL_LOCATION_ATTRIBUTE, $S)", new Object[]{AwsXmlProtocolFactory.class, rootMarshallLocationName});
            initializationCodeBlockBuilder.add(".putAdditionalMetadata($T.XML_NAMESPACE_ATTRIBUTE, $S)", new Object[]{AwsXmlProtocolFactory.class, this.xmlNameSpaceUri()});
        }
        CodeBlock codeBlock = initializationCodeBlockBuilder.add(".build()", new Object[0]).build();
        FieldSpec.Builder instance = FieldSpec.builder((TypeName)ClassName.get(OperationInfo.class), (String)"SDK_OPERATION_BINDING", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(codeBlock);
        fields.add(instance.build());
        fields.add(this.protocolFactory());
        return fields;
    }

    private String xmlNameSpaceUri() {
        if (this.shapeModel.getMarshaller() != null && this.shapeModel.getMarshaller().getXmlNameSpaceUri() != null) {
            return this.shapeModel.getMarshaller().getXmlNameSpaceUri();
        }
        Set xmlUris = this.shapeModel.getMembers().stream().filter(m -> m.getXmlNameSpaceUri() != null).map(MemberModel::getXmlNameSpaceUri).collect(Collectors.toSet());
        if (xmlUris.isEmpty()) {
            return null;
        }
        if (xmlUris.size() == 1) {
            return (String)xmlUris.iterator().next();
        }
        throw new RuntimeException("Request has more than 1 xmlNameSpace uri.");
    }
}

