/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.ServiceModel;

public class UseLegacyEventGenerationSchemeProcessor
implements CodegenCustomizationProcessor {
    private static final String CUSTOMIZATION_NAME = "UseLegacyEventGenerationScheme";
    private static final Logger log = LoggerFactory.getLogger(UseLegacyEventGenerationSchemeProcessor.class);

    @Override
    public void preprocess(ServiceModel serviceModel) {
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        Map<String, List<String>> useLegacyEventGenerationScheme = intermediateModel.getCustomizationConfig().getUseLegacyEventGenerationScheme();
        useLegacyEventGenerationScheme.forEach((eventStream, members) -> {
            ShapeModel shapeModel = this.getShapeByC2jName(intermediateModel, (String)eventStream);
            if (shapeModel == null || !shapeModel.isEventStream()) {
                log.warn(String.format("Encountered %s for unrecognized eventstream %s", CUSTOMIZATION_NAME, eventStream));
                return;
            }
            HashMap<String, Integer> shapeToEventCount = new HashMap<String, Integer>();
            members.forEach(m -> {
                MemberModel event = shapeModel.getMemberByC2jName((String)m);
                if (event != null) {
                    String shapeName = event.getC2jShape();
                    int count = shapeToEventCount.getOrDefault(shapeName, 0);
                    shapeToEventCount.put(shapeName, ++count);
                } else {
                    String msg = String.format("Encountered %s customization for unrecognized eventstream member %s#%s", CUSTOMIZATION_NAME, eventStream, m);
                    log.warn(msg);
                }
            });
            shapeToEventCount.forEach((shape, count) -> {
                if (count > 1) {
                    throw new IllegalArgumentException("UseLegacyEventGenerationScheme customization declared for " + eventStream + ", but more than it targets more than one member with the shape " + shape);
                }
            });
        });
    }

    private ShapeModel getShapeByC2jName(IntermediateModel intermediateModel, String c2jName) {
        return intermediateModel.getShapes().values().stream().filter(s -> s.getC2jName().equals(c2jName)).findAny().orElse(null);
    }
}

