/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public final class Jackson {
    private static final JSON MAPPER;
    private static final JSON FAIL_ON_UNKNOWN_PROPERTIES_MAPPER;
    private static volatile ObjectWriter OBJECT_MAPPER;

    private Jackson() {
    }

    public static JrsValue readJrsValue(String input) throws IOException {
        return (JrsValue)MAPPER.beanFrom(JrsValue.class, (Object)input);
    }

    public static <T> T load(Class<T> clazz, File file) throws IOException {
        return (T)MAPPER.beanFrom(clazz, (Object)file);
    }

    public static <T> T load(Class<T> clazz, File file, boolean failOnUnknownProperties) throws IOException {
        if (failOnUnknownProperties) {
            return (T)FAIL_ON_UNKNOWN_PROPERTIES_MAPPER.beanFrom(clazz, (Object)file);
        }
        return Jackson.load(clazz, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void writeWithObjectMapper(Object value, Writer w) throws IOException {
        if (OBJECT_MAPPER == null) {
            Class<Jackson> clazz = Jackson.class;
            // MONITORENTER : software.amazon.awssdk.codegen.internal.Jackson.class
            if (OBJECT_MAPPER == null) {
                OBJECT_MAPPER = new ObjectMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).writerWithDefaultPrettyPrinter();
            }
            // MONITOREXIT : clazz
        }
        OBJECT_MAPPER.writeValue(w, value);
    }

    static {
        JSON.Builder mapperBuilder = JSON.builder().disable(new JSON.Feature[]{JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY}).enable(new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT}).enable(new JSON.Feature[]{JSON.Feature.READ_JSON_ARRAYS_AS_JAVA_ARRAYS}).treeCodec((TreeCodec)new JacksonJrsTreeCodec());
        mapperBuilder.streamFactory().enable(JsonParser.Feature.ALLOW_COMMENTS);
        MAPPER = mapperBuilder.build();
        mapperBuilder.enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY});
        FAIL_ON_UNKNOWN_PROPERTIES_MAPPER = mapperBuilder.build();
    }
}

