/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.service.Paginators;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Waiters;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public class C2jModels {
    private final ServiceModel serviceModel;
    private final Waiters waitersModel;
    private final CustomizationConfig customizationConfig;
    private final Paginators paginatorsModel;

    private C2jModels(ServiceModel serviceModel, Waiters waitersModel, CustomizationConfig customizationConfig, Paginators paginatorsModel) {
        this.serviceModel = serviceModel;
        this.waitersModel = waitersModel;
        this.customizationConfig = customizationConfig;
        this.paginatorsModel = paginatorsModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServiceModel serviceModel() {
        return this.serviceModel;
    }

    public Waiters waitersModel() {
        return this.waitersModel;
    }

    public CustomizationConfig customizationConfig() {
        return this.customizationConfig;
    }

    public Paginators paginatorsModel() {
        return this.paginatorsModel;
    }

    public static class Builder
    implements SdkBuilder<Builder, C2jModels> {
        private ServiceModel serviceModel;
        private Waiters waitersModel;
        private CustomizationConfig customizationConfig;
        private Paginators paginatorsModel;

        private Builder() {
        }

        public Builder serviceModel(ServiceModel serviceModel) {
            this.serviceModel = serviceModel;
            return this;
        }

        public Builder waitersModel(Waiters waitersModel) {
            this.waitersModel = waitersModel;
            return this;
        }

        public Builder customizationConfig(CustomizationConfig customizationConfig) {
            this.customizationConfig = customizationConfig;
            return this;
        }

        public Builder paginatorsModel(Paginators paginatorsModel) {
            this.paginatorsModel = paginatorsModel;
            return this;
        }

        public C2jModels build() {
            Waiters waiters = this.waitersModel != null ? this.waitersModel : Waiters.none();
            Paginators paginators = this.paginatorsModel != null ? this.paginatorsModel : Paginators.none();
            return new C2jModels(this.serviceModel, waiters, this.customizationConfig, paginators);
        }
    }
}

