/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.auth.token.credentials.aws.DefaultAwsTokenProvider;
import software.amazon.awssdk.auth.token.signer.aws.BearerTokenSigner;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.utils.BearerAuthUtils;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;

public class BaseClientBuilderInterface
implements ClassSpec {
    private final IntermediateModel model;
    private final String basePackage;
    private final ClassName builderInterfaceName;

    public BaseClientBuilderInterface(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createInterfaceBuilder(this.builderInterfaceName).addTypeVariable(PoetUtils.createBoundedTypeVariableName("B", this.builderInterfaceName, "B", "C")).addTypeVariable(TypeVariableName.get((String)"C")).addSuperinterface((TypeName)PoetUtils.createParameterizedTypeName(AwsClientBuilder.class, "B", "C")).addJavadoc(this.getJavadoc());
        if (this.model.getEndpointOperation().isPresent()) {
            if (this.model.getCustomizationConfig().isEnableEndpointDiscoveryMethodRequired()) {
                builder.addMethod(this.enableEndpointDiscovery());
            }
            builder.addMethod(this.endpointDiscovery());
        }
        if (this.model.getCustomizationConfig().getServiceConfig().getClassName() != null) {
            builder.addMethod(this.serviceConfigurationMethod());
            builder.addMethod(this.serviceConfigurationConsumerBuilderMethod());
        }
        if (this.generateTokenProviderMethod()) {
            builder.addMethod(this.tokenProviderMethod());
        }
        return builder.build();
    }

    private CodeBlock getJavadoc() {
        return CodeBlock.of((String)"This includes configuration specific to $L that is supported by both {@link $T} and {@link $T}.", (Object[])new Object[]{this.model.getMetadata().getDescriptiveServiceName(), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getAsyncBuilderInterface(), (String[])new String[0])});
    }

    private MethodSpec enableEndpointDiscovery() {
        return MethodSpec.methodBuilder((String)"enableEndpointDiscovery").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeVariableName.get((String)"B")).addAnnotation(Deprecated.class).addJavadoc("@deprecated Use {@link #endpointDiscoveryEnabled($T)} instead.", new Object[]{Boolean.TYPE}).build();
    }

    private MethodSpec endpointDiscovery() {
        return MethodSpec.methodBuilder((String)"endpointDiscoveryEnabled").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter(Boolean.TYPE, "endpointDiscovery", new Modifier[0]).build();
    }

    private MethodSpec serviceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).build();
    }

    private MethodSpec serviceConfigurationConsumerBuilderMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        ParameterizedTypeName consumerBuilder = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{serviceConfiguration.nestedClass("Builder")});
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)consumerBuilder, "serviceConfiguration", new Modifier[0]).addStatement("return serviceConfiguration($T.builder().applyMutation(serviceConfiguration).build())", new Object[]{serviceConfiguration}).build();
    }

    private boolean generateTokenProviderMethod() {
        return BearerAuthUtils.usesBearerAuth(this.model);
    }

    private MethodSpec tokenProviderMethod() {
        return MethodSpec.methodBuilder((String)"tokenProvider").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter(SdkTokenProvider.class, "tokenProvider", new Modifier[0]).addJavadoc("Set the token provider to use for bearer token authorization. This is optional, if none is provided, the SDK will use {@link $T}.\n<p>\nIf the service, or any of its operations require Bearer Token Authorization, then the SDK will default to this token provider to retrieve the token to use for authorization.\n<p>\nThis provider works in conjunction with the {@code $T.TOKEN_SIGNER} set on the client. By default it is {@link $T}.", new Object[]{DefaultAwsTokenProvider.class, SdkAdvancedClientOption.class, BearerTokenSigner.class}).build();
    }

    @Override
    public ClassName className() {
        return this.builderInterfaceName;
    }
}

