/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.auth.token.credentials.aws.DefaultAwsTokenProvider;
import software.amazon.awssdk.auth.token.signer.aws.BearerTokenSigner;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.utils.BearerAuthUtils;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.endpointdiscovery.providers.DefaultEndpointDiscoveryProviderChain;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

public class BaseClientBuilderClass
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final String basePackage;

    public BaseClientBuilderClass(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(SdkInternalApi.class).addTypeVariable(PoetUtils.createBoundedTypeVariableName("B", this.builderInterfaceName, "B", "C")).addTypeVariable(TypeVariableName.get((String)"C")).superclass((TypeName)PoetUtils.createParameterizedTypeName(AwsDefaultClientBuilder.class, "B", "C")).addJavadoc("Internal base class for {@link $T} and {@link $T}.", new Object[]{ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0])});
        if (this.model.getEndpointOperation().isPresent()) {
            builder.addField(FieldSpec.builder(Boolean.TYPE, (String)"endpointDiscoveryEnabled", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED}).initializer(this.resolveDefaultEndpointDiscovery() ? "true" : "false", new Object[0]).build());
        }
        builder.addMethod(this.serviceEndpointPrefixMethod());
        builder.addMethod(this.serviceNameMethod());
        builder.addMethod(this.mergeServiceDefaultsMethod());
        this.mergeInternalDefaultsMethod().ifPresent(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        builder.addMethod(this.finalizeServiceConfigurationMethod());
        this.defaultAwsAuthSignerMethod().ifPresent(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        builder.addMethod(this.signingNameMethod());
        if (this.model.getCustomizationConfig().getServiceConfig().getClassName() != null) {
            builder.addMethod(this.setServiceConfigurationMethod()).addMethod(this.beanStyleSetServiceConfigurationMethod());
        }
        if (BearerAuthUtils.usesBearerAuth(this.model)) {
            builder.addMethod(this.defaultBearerTokenProviderMethod());
            builder.addMethod(this.defaultTokenAuthSignerMethod());
        }
        this.addServiceHttpConfigIfNeeded(builder, this.model);
        return builder.build();
    }

    private boolean resolveDefaultEndpointDiscovery() {
        return this.model.getEndpointOperation().map(OperationModel::isEndpointCacheRequired).orElse(false);
    }

    private MethodSpec signingNameMethod() {
        return MethodSpec.methodBuilder((String)"signingName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getSigningName()}).build();
    }

    private Optional<MethodSpec> defaultAwsAuthSignerMethod() {
        return this.awsAuthSignerDefinitionMethodBody().map(body -> MethodSpec.methodBuilder((String)"defaultSigner").returns(Signer.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode(body).build());
    }

    private MethodSpec serviceEndpointPrefixMethod() {
        return MethodSpec.methodBuilder((String)"serviceEndpointPrefix").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getEndpointPrefix()}).build();
    }

    private MethodSpec serviceNameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getServiceName()}).build();
    }

    private MethodSpec mergeServiceDefaultsMethod() {
        boolean crc32FromCompressedDataEnabled = this.model.getCustomizationConfig().isCalculateCrc32FromCompressedData();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"mergeServiceDefaults").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("return config.merge(c -> c", new Object[0]);
        if (this.defaultAwsAuthSignerMethod().isPresent()) {
            builder.addCode(".option($T.SIGNER, defaultSigner())\n", new Object[]{SdkAdvancedClientOption.class});
        }
        builder.addCode(".option($T.CRC32_FROM_COMPRESSED_DATA_ENABLED, $L)\n", new Object[]{SdkClientOption.class, crc32FromCompressedDataEnabled});
        String clientConfigClassName = this.model.getCustomizationConfig().getServiceConfig().getClassName();
        if (StringUtils.isNotBlank((CharSequence)clientConfigClassName)) {
            builder.addCode(".option($T.SERVICE_CONFIGURATION, $T.builder().build())\n", new Object[]{SdkClientOption.class, ClassName.bestGuess((String)clientConfigClassName)});
        }
        if (BearerAuthUtils.usesBearerAuth(this.model)) {
            builder.addCode(".option($T.TOKEN_PROVIDER, defaultTokenProvider())\n", new Object[]{AwsClientOption.class});
            builder.addCode(".option($T.TOKEN_SIGNER, defaultTokenSigner())", new Object[]{SdkAdvancedClientOption.class});
        }
        builder.addCode(");", new Object[0]);
        return builder.build();
    }

    private Optional<MethodSpec> mergeInternalDefaultsMethod() {
        String userAgent = this.model.getCustomizationConfig().getUserAgent();
        RetryMode defaultRetryMode = this.model.getCustomizationConfig().getDefaultRetryMode();
        if (userAgent == null && defaultRetryMode == null) {
            return Optional.empty();
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"mergeInternalDefaults").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("return config.merge(c -> {\n", new Object[0]);
        if (userAgent != null) {
            builder.addCode("c.option($T.INTERNAL_USER_AGENT, $S);\n", new Object[]{SdkClientOption.class, userAgent});
        }
        if (defaultRetryMode != null) {
            builder.addCode("c.option($T.DEFAULT_RETRY_MODE, $T.$L);\n", new Object[]{SdkClientOption.class, RetryMode.class, defaultRetryMode.name()});
        }
        builder.addCode("});\n", new Object[0]);
        return Optional.of(builder.build());
    }

    private MethodSpec finalizeServiceConfigurationMethod() {
        String clientConfigClassName;
        String requestHandlerDirectory = Utils.packageToDirectory(this.model.getMetadata().getFullClientPackageName());
        String requestHandlerPath = String.format("%s/execution.interceptors", requestHandlerDirectory);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"finalizeServiceConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]);
        builder.addCode("$1T interceptorFactory = new $1T();\n", new Object[]{ClasspathInterceptorChainFactory.class}).addCode("$T<$T> interceptors = interceptorFactory.getInterceptors($S);\n", new Object[]{List.class, ExecutionInterceptor.class, requestHandlerPath}).addCode("interceptors = $T.mergeLists(interceptors, config.option($T.EXECUTION_INTERCEPTORS));\n", new Object[]{CollectionUtils.class, SdkClientOption.class});
        if (this.model.getMetadata().isQueryProtocol()) {
            ParameterizedTypeName listType = ParameterizedTypeName.get(List.class, (Type[])new Type[]{ExecutionInterceptor.class});
            builder.addStatement("$T protocolInterceptors = $T.singletonList(new $T())", new Object[]{listType, Collections.class, QueryParametersToBodyInterceptor.class});
            builder.addStatement("interceptors = $T.mergeLists(interceptors, protocolInterceptors)", new Object[]{CollectionUtils.class});
        }
        if (this.model.getEndpointOperation().isPresent()) {
            builder.beginControlFlow("if (!endpointDiscoveryEnabled)", new Object[0]).addStatement("$1T chain = new $1T(config)", new Object[]{DefaultEndpointDiscoveryProviderChain.class}).addStatement("endpointDiscoveryEnabled = chain.resolveEndpointDiscovery()", new Object[0]).endControlFlow();
        }
        if (StringUtils.isNotBlank((CharSequence)(clientConfigClassName = this.model.getCustomizationConfig().getServiceConfig().getClassName()))) {
            ClassName clientConfigClass = ClassName.bestGuess((String)clientConfigClassName);
            builder.addCode("$1T.Builder c = (($1T) config.option($2T.SERVICE_CONFIGURATION)).toBuilder();c.profileFile(c.profileFile() != null ? c.profileFile() : config.option($2T.PROFILE_FILE));c.profileName(c.profileName() != null ? c.profileName() : config.option($2T.PROFILE_NAME));", new Object[]{clientConfigClass, SdkClientOption.class});
            if (this.model.getCustomizationConfig().getServiceConfig().hasDualstackProperty()) {
                builder.addCode("if (c.dualstackEnabled() != null) {", new Object[0]).addCode("    $T.validState(config.option($T.DUALSTACK_ENDPOINT_ENABLED) == null, \"Dualstack has been configured on both $L and the client/global level. Please limit dualstack configuration to one location.\");", new Object[]{Validate.class, AwsClientOption.class, clientConfigClassName}).addCode("} else {", new Object[0]).addCode("    c.dualstackEnabled(config.option($T.DUALSTACK_ENDPOINT_ENABLED));", new Object[]{AwsClientOption.class}).addCode("}", new Object[0]);
            }
            if (this.model.getCustomizationConfig().getServiceConfig().hasFipsProperty()) {
                builder.addCode("if (c.fipsModeEnabled() != null) {", new Object[0]).addCode("    $T.validState(config.option($T.FIPS_ENDPOINT_ENABLED) == null, \"Fips has been configured on both $L and the client/global level. Please limit fips configuration to one location.\");", new Object[]{Validate.class, AwsClientOption.class, clientConfigClassName}).addCode("} else {", new Object[0]).addCode("    c.fipsModeEnabled(config.option($T.FIPS_ENDPOINT_ENABLED));", new Object[]{AwsClientOption.class}).addCode("}", new Object[0]);
            }
        }
        builder.addCode("return config.toBuilder()\n", new Object[0]);
        if (this.model.getCustomizationConfig().getServiceConfig().hasDualstackProperty()) {
            builder.addCode(".option($T.DUALSTACK_ENDPOINT_ENABLED, c.dualstackEnabled())", new Object[]{AwsClientOption.class});
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasFipsProperty()) {
            builder.addCode(".option($T.FIPS_ENDPOINT_ENABLED, c.fipsModeEnabled())", new Object[]{AwsClientOption.class});
        }
        if (this.model.getEndpointOperation().isPresent()) {
            builder.addCode(".option($T.ENDPOINT_DISCOVERY_ENABLED, endpointDiscoveryEnabled)\n", new Object[]{SdkClientOption.class});
        }
        builder.addCode(".option($1T.EXECUTION_INTERCEPTORS, interceptors)", new Object[]{SdkClientOption.class});
        if (StringUtils.isNotBlank((CharSequence)this.model.getCustomizationConfig().getCustomRetryPolicy())) {
            builder.addCode(".option($1T.RETRY_POLICY, $2T.resolveRetryPolicy(config))", new Object[]{SdkClientOption.class, PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getCustomRetryPolicy())});
        }
        if (StringUtils.isNotBlank((CharSequence)clientConfigClassName)) {
            builder.addCode(".option($T.SERVICE_CONFIGURATION, c.build())", new Object[]{SdkClientOption.class});
        }
        builder.addCode(".build();", new Object[0]);
        return builder.build();
    }

    private MethodSpec setServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("clientConfiguration.option($T.SERVICE_CONFIGURATION, serviceConfiguration)", new Object[]{SdkClientOption.class}).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec beanStyleSetServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"setServiceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("serviceConfiguration(serviceConfiguration)", new Object[0]).build();
    }

    private void addServiceHttpConfigIfNeeded(TypeSpec.Builder builder, IntermediateModel model) {
        String serviceDefaultFqcn = model.getCustomizationConfig().getServiceSpecificHttpConfig();
        boolean supportsH2 = model.getMetadata().supportsH2();
        if (serviceDefaultFqcn != null || supportsH2) {
            builder.addMethod(this.serviceSpecificHttpConfigMethod(serviceDefaultFqcn, supportsH2));
        }
    }

    private MethodSpec serviceSpecificHttpConfigMethod(String serviceDefaultFqcn, boolean supportsH2) {
        return MethodSpec.methodBuilder((String)"serviceHttpConfig").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(AttributeMap.class).addCode(this.serviceSpecificHttpConfigMethodBody(serviceDefaultFqcn, supportsH2)).build();
    }

    private CodeBlock serviceSpecificHttpConfigMethodBody(String serviceDefaultFqcn, boolean supportsH2) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (serviceDefaultFqcn != null) {
            builder.addStatement("$T result = $T.defaultHttpConfig()", new Object[]{AttributeMap.class, PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getServiceSpecificHttpConfig())});
        } else {
            builder.addStatement("$1T result = $1T.empty()", new Object[]{AttributeMap.class});
        }
        if (supportsH2) {
            builder.addStatement("return result.merge(AttributeMap.builder().put($T.PROTOCOL, $T.HTTP2).build())", new Object[]{SdkHttpConfigurationOption.class, Protocol.class});
        } else {
            builder.addStatement("return result", new Object[0]);
        }
        return builder.build();
    }

    private Optional<CodeBlock> awsAuthSignerDefinitionMethodBody() {
        AuthType authType = this.model.getMetadata().getAuthType();
        switch (authType) {
            case V4: {
                return Optional.of(this.v4SignerDefinitionMethodBody());
            }
            case S3: 
            case S3V4: {
                return Optional.of(this.s3SignerDefinitionMethodBody());
            }
            case BEARER: {
                return Optional.empty();
            }
        }
        throw new UnsupportedOperationException("Unsupported signer type: " + (Object)((Object)authType));
    }

    private CodeBlock v4SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();", (Object[])new Object[]{Aws4Signer.class});
    }

    private CodeBlock s3SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();\n", (Object[])new Object[]{ClassName.get((String)"software.amazon.awssdk.auth.signer", (String)"AwsS3V4Signer", (String[])new String[0])});
    }

    private MethodSpec defaultBearerTokenProviderMethod() {
        return MethodSpec.methodBuilder((String)"defaultTokenProvider").returns(SdkTokenProvider.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return $T.create()", new Object[]{DefaultAwsTokenProvider.class}).build();
    }

    private MethodSpec defaultTokenAuthSignerMethod() {
        return MethodSpec.methodBuilder((String)"defaultTokenSigner").returns(Signer.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return $T.create()", new Object[]{BearerTokenSigner.class}).build();
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }
}

