/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.codegen.IntermediateModelBuilder;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.ExceptionModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.model.service.ErrorMap;
import software.amazon.awssdk.codegen.model.service.ErrorTrait;
import software.amazon.awssdk.codegen.model.service.Input;
import software.amazon.awssdk.codegen.model.service.Member;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.Output;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.naming.NamingStrategy;

final class AddOperations {
    private final ServiceModel serviceModel;
    private final NamingStrategy namingStrategy;
    private final Map<String, PaginatorDefinition> paginators;
    private final List<String> deprecatedShapes;

    AddOperations(IntermediateModelBuilder builder) {
        this.serviceModel = builder.getService();
        this.namingStrategy = builder.getNamingStrategy();
        this.paginators = builder.getPaginators().getPagination();
        this.deprecatedShapes = builder.getCustomConfig().getDeprecatedShapes();
    }

    private static boolean isAuthenticated(Operation op) {
        return op.getAuthtype() == null || op.getAuthtype() != AuthType.NONE;
    }

    private static String getOperationDocumentation(Output output, Shape outputShape) {
        return output.getDocumentation() != null ? output.getDocumentation() : outputShape.getDocumentation();
    }

    private static boolean isBlobShape(Shape shape) {
        return shape != null && "blob".equals(shape.getType());
    }

    public static Shape getPayloadShape(Map<String, Shape> c2jShapes, Shape outputShape) {
        if (outputShape.getPayload() == null) {
            return null;
        }
        Member payloadMember = outputShape.getMembers().get(outputShape.getPayload());
        return c2jShapes.get(payloadMember.getShape());
    }

    private static String getResultShapeName(Operation operation, Map<String, Shape> shapes) {
        Output output = operation.getOutput();
        if (output == null) {
            return null;
        }
        Shape outputShape = shapes.get(output.getShape());
        if (outputShape.getMembers().keySet().size() != 1) {
            return output.getShape();
        }
        Member wrappedMember = outputShape.getMembers().values().toArray(new Member[0])[0];
        Shape wrappedResult = shapes.get(wrappedMember.getShape());
        return wrappedResult.isWrapper() ? wrappedMember.getShape() : output.getShape();
    }

    public Map<String, OperationModel> constructOperations() {
        TreeMap<String, OperationModel> javaOperationModels = new TreeMap<String, OperationModel>();
        Map<String, Shape> c2jShapes = this.serviceModel.getShapes();
        for (Map.Entry<String, Operation> entry : this.serviceModel.getOperations().entrySet()) {
            Output output;
            String operationName = entry.getKey();
            Operation op = entry.getValue();
            OperationModel operationModel = new OperationModel();
            operationModel.setOperationName(operationName);
            operationModel.setDeprecated(op.isDeprecated());
            operationModel.setDeprecatedMessage(op.getDeprecatedMessage());
            operationModel.setDocumentation(op.getDocumentation());
            operationModel.setIsAuthenticated(AddOperations.isAuthenticated(op));
            operationModel.setAuthType(op.getAuthtype());
            operationModel.setPaginated(this.isPaginated(op));
            operationModel.setEndpointOperation(op.isEndpointoperation());
            operationModel.setEndpointDiscovery(op.getEndpointdiscovery());
            operationModel.setEndpointTrait(op.getEndpoint());
            operationModel.setHttpChecksumRequired(op.isHttpChecksumRequired());
            operationModel.setHttpChecksum(op.getHttpChecksum());
            Input input = op.getInput();
            if (input != null) {
                String originalShapeName = input.getShape();
                String inputShape = this.namingStrategy.getRequestClassName(operationName);
                String documentation = input.getDocumentation() != null ? input.getDocumentation() : c2jShapes.get(originalShapeName).getDocumentation();
                operationModel.setInput(new VariableModel(Utils.unCapitalize(inputShape), inputShape).withDocumentation(documentation));
            }
            if ((output = op.getOutput()) != null) {
                String outputShapeName = AddOperations.getResultShapeName(op, c2jShapes);
                Shape outputShape = c2jShapes.get(outputShapeName);
                String responseClassName = this.namingStrategy.getResponseClassName(operationName);
                String documentation = AddOperations.getOperationDocumentation(output, outputShape);
                operationModel.setReturnType(new ReturnTypeModel(responseClassName).withDocumentation(documentation));
                if (AddOperations.isBlobShape(AddOperations.getPayloadShape(c2jShapes, outputShape))) {
                    operationModel.setHasBlobMemberAsPayload(true);
                }
            }
            if (op.getErrors() != null) {
                for (ErrorMap error : op.getErrors()) {
                    String documentation = error.getDocumentation() != null ? error.getDocumentation() : c2jShapes.get(error.getShape()).getDocumentation();
                    Integer httpStatusCode = this.getHttpStatusCode(error, c2jShapes.get(error.getShape()));
                    if (this.deprecatedShapes.contains(error.getShape())) continue;
                    operationModel.addException(new ExceptionModel(this.namingStrategy.getExceptionName(error.getShape())).withDocumentation(documentation).withHttpStatusCode(httpStatusCode));
                }
            }
            javaOperationModels.put(operationName, operationModel);
        }
        return javaOperationModels;
    }

    private Integer getHttpStatusCode(ErrorMap error, Shape shape) {
        Integer httpStatusCode = this.getHttpStatusCode(error.getError());
        return httpStatusCode == null ? this.getHttpStatusCode(shape.getError()) : httpStatusCode;
    }

    private Integer getHttpStatusCode(ErrorTrait errorTrait) {
        return errorTrait == null ? null : errorTrait.getHttpStatusCode();
    }

    private boolean isPaginated(Operation op) {
        return this.paginators.containsKey(op.getName()) && this.paginators.get(op.getName()).isValid();
    }
}

