/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamVisitorBuilderInterfaceSpec;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;

class EventStreamVisitorInterfaceSpec
implements ClassSpec {
    private final PoetExtensions poetExt;
    private final IntermediateModel intermediateModel;
    private final OperationModel operationModel;
    private final ShapeModel eventStreamShape;
    private final ClassName eventStreamBaseClass;
    private final EventStreamSpecHelper eventStreamSpecHelper;

    EventStreamVisitorInterfaceSpec(IntermediateModel intermediateModel, PoetExtensions poetExt, OperationModel operationModel) {
        this.poetExt = poetExt;
        this.intermediateModel = intermediateModel;
        this.operationModel = operationModel;
        this.eventStreamShape = EventStreamUtils.getEventStreamInResponse(operationModel.getOutputShape());
        this.eventStreamBaseClass = poetExt.getModelClassFromShape(this.eventStreamShape);
        this.eventStreamSpecHelper = new EventStreamSpecHelper(this.eventStreamShape, intermediateModel);
    }

    @Override
    public final TypeSpec poetSpec() {
        TypeSpec.Builder typeBuilder = this.createTypeSpec().addMethod(this.applyVisitDefaultMethodSpecUpdates(this.createVisitDefaultMethodSpec()).build());
        EventStreamUtils.getEvents(this.eventStreamShape).forEach(e -> typeBuilder.addMethod(this.applyVisitSubTypeMethodSpecUpdates(typeBuilder, this.createVisitSubTypeMethodSpec((MemberModel)e), (MemberModel)e).build()));
        return this.finalizeTypeSpec(typeBuilder).build();
    }

    @Override
    public ClassName className() {
        return this.poetExt.eventStreamResponseHandlerVisitorType(this.operationModel);
    }

    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createInterfaceBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Visitor for subtypes of {@link $T}.", new Object[]{this.eventStreamBaseClass}).addMethod(this.createBuilderMethodSpec()).addType(new EventStreamVisitorBuilderInterfaceSpec(this.poetExt, this.intermediateModel, this.operationModel).poetSpec());
    }

    protected TypeSpec.Builder finalizeTypeSpec(TypeSpec.Builder builder) {
        return builder;
    }

    private MethodSpec.Builder createVisitDefaultMethodSpec() {
        return MethodSpec.methodBuilder((String)"visitDefault").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)this.eventStreamBaseClass, (String)"event", (Modifier[])new Modifier[0]).build());
    }

    protected MethodSpec.Builder applyVisitDefaultMethodSpecUpdates(MethodSpec.Builder builder) {
        String javadocs = new DocumentationBuilder().description("A required \"else\" or \"default\" block, invoked when no other more-specific \"visit\" method is appropriate. This is invoked under two circumstances:\n<ol>\n<li>The event encountered is newer than the current version of the SDK, so no other more-specific \"visit\" method could be called. In this case, the provided event will be a generic {@link $1T}. These events can be processed by upgrading the SDK.</li>\n<li>The event is known by the SDK, but the \"visit\" was not overridden above. In this case, the provided event will be a specific type of {@link $1T}.</li>\n</ol>").param("event", "The event that was not handled by a more-specific \"visit\" method.").build();
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT}).addJavadoc(javadocs, new Object[]{this.eventStreamBaseClass});
    }

    private MethodSpec.Builder createVisitSubTypeMethodSpec(MemberModel event) {
        ClassName eventSubType = this.poetExt.getModelClass(event.getShape().getShapeName());
        return MethodSpec.methodBuilder((String)this.visitorMethodName(event)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)eventSubType, (String)"event", (Modifier[])new Modifier[0]).build());
    }

    protected MethodSpec.Builder applyVisitSubTypeMethodSpecUpdates(TypeSpec.Builder typeBuilder, MethodSpec.Builder methodBuilder, MemberModel event) {
        ClassName eventSubType = this.poetExt.getModelClass(event.getShape().getShapeName());
        String javadocs = new DocumentationBuilder().description("Invoked when a {@link $T} is encountered. If this is not overridden, the event will be given to {@link #visitDefault($T)}.").param("event", "Event being visited").build();
        return methodBuilder.addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("visitDefault(event)", new Object[0]).addJavadoc(javadocs, new Object[]{eventSubType, this.eventStreamBaseClass});
    }

    protected String visitorMethodName(MemberModel event) {
        return this.eventStreamSpecHelper.visitMethodName(event);
    }

    private MethodSpec createBuilderMethodSpec() {
        ClassName visitorBuilderType = this.poetExt.eventStreamResponseHandlerVisitorBuilderType(this.operationModel);
        return MethodSpec.methodBuilder((String)"builder").addJavadoc("@return A new {@link Builder}.", new Object[]{visitorBuilderType}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)visitorBuilderType).addStatement("return new Default$LVisitorBuilder()", new Object[]{this.poetExt.getApiName(this.operationModel)}).build();
    }
}

