/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.ModifyModelShapeModifier;
import software.amazon.awssdk.codegen.model.config.customization.ShapeModifier;
import software.amazon.awssdk.codegen.model.intermediate.EnumModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.Member;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;

final class ShapeModifiersProcessor
implements CodegenCustomizationProcessor {
    private static final String ALL = "*";
    private final Map<String, ShapeModifier> shapeModifiers;

    ShapeModifiersProcessor(Map<String, ShapeModifier> shapeModifiers) {
        this.shapeModifiers = shapeModifiers;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.shapeModifiers == null) {
            return;
        }
        for (Map.Entry<String, ShapeModifier> entry : this.shapeModifiers.entrySet()) {
            String key = entry.getKey();
            ShapeModifier modifier = entry.getValue();
            if (ALL.equals(key)) {
                for (Shape shape : serviceModel.getShapes().values()) {
                    this.preprocessModifyShapeMembers(serviceModel, shape, modifier);
                }
                continue;
            }
            Shape shape = serviceModel.getShapes().get(key);
            if (shape == null) {
                throw new IllegalStateException("ShapeModifier customization found for " + key + ", but this shape doesn't exist in the model!");
            }
            this.preprocessModifyShapeMembers(serviceModel, shape, modifier);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.shapeModifiers == null) {
            return;
        }
        for (Map.Entry<String, ShapeModifier> entry : this.shapeModifiers.entrySet()) {
            String key = entry.getKey();
            ShapeModifier modifier = entry.getValue();
            if (ALL.equals(key)) continue;
            List<ShapeModel> shapeModels = Utils.findShapesByC2jName(intermediateModel, key);
            if (shapeModels.isEmpty()) {
                throw new IllegalStateException(String.format("Cannot find c2j shape [%s] in the intermediate model when processing customization config shapeModifiers.%s", key, key));
            }
            shapeModels.forEach(shapeModel -> {
                if (modifier.getStaxTargetDepthOffset() != null) {
                    shapeModel.getCustomization().setStaxTargetDepthOffset(modifier.getStaxTargetDepthOffset());
                }
                if (modifier.isExcludeShape()) {
                    shapeModel.getCustomization().setSkipGeneratingModelClass(true);
                    shapeModel.getCustomization().setSkipGeneratingMarshaller(true);
                    shapeModel.getCustomization().setSkipGeneratingUnmarshaller(true);
                } else if (modifier.getModify() != null) {
                    modifier.getModify().stream().flatMap(m -> m.entrySet().stream()).forEach(memberEntry -> this.postprocessModifyMemberProperty((ShapeModel)shapeModel, (String)memberEntry.getKey(), (ModifyModelShapeModifier)memberEntry.getValue()));
                }
            });
        }
    }

    private void postprocessModifyMemberProperty(ShapeModel shapeModel, String memberName, ModifyModelShapeModifier modifyModel) {
        MemberModel memberModel;
        EnumModel enumModel;
        if (modifyModel.getEmitEnumName() != null) {
            enumModel = shapeModel.findEnumModelByValue(memberName);
            if (enumModel == null) {
                throw new IllegalStateException(String.format("Cannot find enum [%s] in the intermediate model when processing customization config shapeModifiers.%s", memberName, memberName));
            }
            enumModel.setName(modifyModel.getEmitEnumName());
        }
        if (modifyModel.getEmitEnumValue() != null) {
            enumModel = shapeModel.findEnumModelByValue(memberName);
            if (enumModel == null) {
                throw new IllegalStateException(String.format("Cannot find enum [%s] in the intermediate model when processing customization config shapeModifiers.%s", memberName, memberName));
            }
            enumModel.setValue(modifyModel.getEmitEnumValue());
        }
        if (modifyModel.getMarshallLocationName() != null) {
            memberModel = shapeModel.findMemberModelByC2jName(memberName);
            memberModel.getHttp().setMarshallLocationName(modifyModel.getMarshallLocationName());
        }
        if (modifyModel.getUnmarshallLocationName() != null) {
            memberModel = shapeModel.findMemberModelByC2jName(memberName);
            memberModel.getHttp().setUnmarshallLocationName(modifyModel.getUnmarshallLocationName());
        }
    }

    private void preprocessModifyShapeMembers(ServiceModel serviceModel, Shape shape, ShapeModifier modifier) {
        if (modifier.getModify() != null) {
            for (Map map : modifier.getModify()) {
                for (Map.Entry entry : map.entrySet()) {
                    String memberToModify = (String)entry.getKey();
                    ModifyModelShapeModifier modifyModel = (ModifyModelShapeModifier)entry.getValue();
                    this.doModifyShapeMembers(serviceModel, shape, memberToModify, modifyModel);
                }
            }
        }
        if (modifier.getExclude() != null) {
            for (String string : modifier.getExclude()) {
                if (shape.getRequired() != null && shape.getRequired().contains(string)) {
                    throw new IllegalStateException("ShapeModifier.exclude customization found for " + string + ", but this member is marked as required in the model!");
                }
                if (shape.getMembers() == null) continue;
                shape.getMembers().remove(string);
            }
        }
        if (modifier.getInject() != null) {
            for (Map map : modifier.getInject()) {
                if (shape.getMembers() == null) {
                    shape.setMembers(new HashMap<String, Member>());
                }
                shape.getMembers().putAll(map);
            }
        }
    }

    private void doModifyShapeMembers(ServiceModel serviceModel, Shape shape, String memberToModify, ModifyModelShapeModifier modifyModel) {
        Member member;
        if (modifyModel.isDeprecated()) {
            member = shape.getMembers().get(memberToModify);
            member.setDeprecated(true);
            if (modifyModel.getDeprecatedMessage() != null) {
                member.setDeprecatedMessage(modifyModel.getDeprecatedMessage());
            }
        }
        if (modifyModel.getEmitPropertyName() != null) {
            member = shape.getMembers().remove(memberToModify);
            if (member.getLocationName() == null) {
                member.setLocationName(memberToModify);
            }
            if (modifyModel.isExistingNameDeprecated()) {
                member.setDeprecatedName(memberToModify);
            }
            shape.getMembers().put(modifyModel.getEmitPropertyName(), member);
        }
        if (modifyModel.getEmitAsType() != null) {
            Shape newShapeForType = new Shape();
            newShapeForType.setType(modifyModel.getEmitAsType());
            String shapeName = "SDK_" + modifyModel.getEmitAsType();
            serviceModel.getShapes().put(shapeName, newShapeForType);
            shape.getMembers().get(memberToModify).setShape(shapeName);
        }
    }
}

