/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.jmespath.component;

import software.amazon.awssdk.codegen.jmespath.component.SliceExpression;
import software.amazon.awssdk.codegen.jmespath.component.WildcardExpression;
import software.amazon.awssdk.codegen.jmespath.parser.JmesPathVisitor;
import software.amazon.awssdk.utils.Validate;

public class BracketSpecifierWithContents {
    private Integer number;
    private WildcardExpression wildcardExpression;
    private SliceExpression sliceExpression;

    private BracketSpecifierWithContents() {
    }

    public static BracketSpecifierWithContents number(Integer number) {
        Validate.notNull((Object)number, (String)"number", (Object[])new Object[0]);
        BracketSpecifierWithContents result = new BracketSpecifierWithContents();
        result.number = number;
        return result;
    }

    public static BracketSpecifierWithContents wildcardExpression(WildcardExpression wildcardExpression) {
        Validate.notNull((Object)wildcardExpression, (String)"wildcardExpression", (Object[])new Object[0]);
        BracketSpecifierWithContents result = new BracketSpecifierWithContents();
        result.wildcardExpression = wildcardExpression;
        return result;
    }

    public static BracketSpecifierWithContents sliceExpression(SliceExpression sliceExpression) {
        Validate.notNull((Object)sliceExpression, (String)"sliceExpression", (Object[])new Object[0]);
        BracketSpecifierWithContents result = new BracketSpecifierWithContents();
        result.sliceExpression = sliceExpression;
        return result;
    }

    public boolean isNumber() {
        return this.number != null;
    }

    public boolean isWildcardExpression() {
        return this.wildcardExpression != null;
    }

    public boolean isSliceExpression() {
        return this.sliceExpression != null;
    }

    public int asNumber() {
        Validate.validState((boolean)this.isNumber(), (String)"Not a Number", (Object[])new Object[0]);
        return this.number;
    }

    public WildcardExpression asWildcardExpression() {
        Validate.validState((boolean)this.isWildcardExpression(), (String)"Not a WildcardExpression", (Object[])new Object[0]);
        return this.wildcardExpression;
    }

    public SliceExpression asSliceExpression() {
        Validate.validState((boolean)this.isSliceExpression(), (String)"Not a SliceExpression", (Object[])new Object[0]);
        return this.sliceExpression;
    }

    public void visit(JmesPathVisitor visitor) {
        if (this.isNumber()) {
            visitor.visitNumber(this.asNumber());
        } else if (this.isWildcardExpression()) {
            visitor.visitWildcardExpression(this.asWildcardExpression());
        } else if (this.isSliceExpression()) {
            visitor.visitSliceExpression(this.asSliceExpression());
        } else {
            throw new IllegalStateException();
        }
    }
}

