/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamResponseHandlerBuilderInterfaceSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamVisitorInterfaceSpec;

public class EventStreamResponseHandlerSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final PoetExtensions poetExt;
    private final OperationModel operationModel;
    private final String apiName;
    private final ClassName responsePojoType;
    private final ClassName responseHandlerBuilderType;
    private final ClassName eventStreamBaseClass;

    public EventStreamResponseHandlerSpec(GeneratorTaskParams params, OperationModel operationModel) {
        this.intermediateModel = params.getModel();
        this.poetExt = params.getPoetExtensions();
        this.operationModel = operationModel;
        this.apiName = this.poetExt.getApiName(operationModel);
        this.responsePojoType = this.poetExt.responsePojoType(operationModel);
        this.responseHandlerBuilderType = this.poetExt.eventStreamResponseHandlerBuilderType(operationModel);
        this.eventStreamBaseClass = this.poetExt.getModelClassFromShape(EventStreamUtils.getEventStreamInResponse(operationModel.getOutputShape()));
    }

    @Override
    public TypeSpec poetSpec() {
        ParameterizedTypeName superResponseHandlerInterface = ParameterizedTypeName.get((ClassName)ClassName.get(EventStreamResponseHandler.class), (TypeName[])new TypeName[]{this.responsePojoType, this.eventStreamBaseClass});
        return PoetUtils.createInterfaceBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(SdkPublicApi.class).addSuperinterface((TypeName)superResponseHandlerInterface).addJavadoc("Response handler for the $L API.", new Object[]{this.apiName}).addMethod(this.builderMethodSpec()).addType(new EventStreamResponseHandlerBuilderInterfaceSpec(this.poetExt, this.operationModel).poetSpec()).addType(new EventStreamVisitorInterfaceSpec(this.intermediateModel, this.poetExt, this.operationModel).poetSpec()).build();
    }

    @Override
    public ClassName className() {
        return this.poetExt.eventStreamResponseHandlerType(this.operationModel);
    }

    private MethodSpec builderMethodSpec() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Create a {@link $T}, used to create a {@link $T}.", new Object[]{this.responseHandlerBuilderType, this.className()}).addStatement("return new $T()", new Object[]{this.poetExt.getModelClass(String.format("Default%sResponseHandlerBuilder", this.apiName))}).returns((TypeName)this.responseHandlerBuilderType).build();
    }
}

