/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.AddCustomAuthorizers;
import software.amazon.awssdk.codegen.AddEmptyInputShape;
import software.amazon.awssdk.codegen.AddEmptyOutputShape;
import software.amazon.awssdk.codegen.AddExceptionShapes;
import software.amazon.awssdk.codegen.AddInputShapes;
import software.amazon.awssdk.codegen.AddMetadata;
import software.amazon.awssdk.codegen.AddModelShapes;
import software.amazon.awssdk.codegen.AddOperations;
import software.amazon.awssdk.codegen.AddOutputShapes;
import software.amazon.awssdk.codegen.C2jModels;
import software.amazon.awssdk.codegen.ExamplesCustomizer;
import software.amazon.awssdk.codegen.IntermediateModelShapeProcessor;
import software.amazon.awssdk.codegen.RemoveUnusedShapes;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.customization.processors.DefaultCustomizationProcessor;
import software.amazon.awssdk.codegen.internal.TypeUtils;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.AuthorizerModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ServiceExamples;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.Paginators;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.naming.DefaultNamingStrategy;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.CollectionUtils;

public class IntermediateModelBuilder {
    private static final Logger log = LoggerFactory.getLogger(IntermediateModelBuilder.class);
    private final CustomizationConfig customConfig;
    private final ServiceModel service;
    private final ServiceExamples examples;
    private final NamingStrategy namingStrategy;
    private final TypeUtils typeUtils;
    private final List<IntermediateModelShapeProcessor> shapeProcessors;
    private final Paginators paginators;

    public IntermediateModelBuilder(C2jModels models) {
        this.customConfig = models.customizationConfig();
        this.service = models.serviceModel();
        this.examples = models.examplesModel();
        this.namingStrategy = new DefaultNamingStrategy(this.service, this.customConfig);
        this.typeUtils = new TypeUtils(this.namingStrategy);
        this.shapeProcessors = this.createShapeProcessors();
        this.paginators = models.paginatorsModel();
    }

    private List<IntermediateModelShapeProcessor> createShapeProcessors() {
        ArrayList<IntermediateModelShapeProcessor> processors = new ArrayList<IntermediateModelShapeProcessor>();
        processors.add(new AddInputShapes(this));
        processors.add(new AddOutputShapes(this));
        processors.add(new AddExceptionShapes(this));
        processors.add(new AddModelShapes(this));
        processors.add(new AddEmptyInputShape(this));
        processors.add(new AddEmptyOutputShape(this));
        return processors;
    }

    public IntermediateModel build() {
        log.info("Applying customizations to examples...");
        new ExamplesCustomizer(this.service, this.customConfig).applyCustomizationsToExamples(this.examples);
        log.info("Examples customized.");
        CodegenCustomizationProcessor customization = DefaultCustomizationProcessor.getProcessorFor(this.customConfig);
        customization.preprocess(this.service);
        HashMap<String, ShapeModel> shapes = new HashMap<String, ShapeModel>();
        TreeMap<String, OperationModel> operations = new TreeMap<String, OperationModel>(new AddOperations(this).constructOperations());
        HashMap<String, AuthorizerModel> authorizers = new HashMap<String, AuthorizerModel>(new AddCustomAuthorizers(this.service, this.getNamingStrategy()).constructAuthorizers());
        OperationModel endpointOperation = null;
        for (OperationModel o : operations.values()) {
            if (!o.isEndpointOperation()) continue;
            endpointOperation = o;
            break;
        }
        for (IntermediateModelShapeProcessor processor : this.shapeProcessors) {
            shapes.putAll(processor.process(Collections.unmodifiableMap(operations), Collections.unmodifiableMap(shapes)));
        }
        operations.entrySet().removeIf(e -> this.customConfig.getDeprecatedOperations().contains(e.getKey()));
        this.paginators.getPaginators().entrySet().removeIf(e -> this.customConfig.getDeprecatedOperations().contains(e.getKey()));
        log.info("{} shapes found in total.", (Object)shapes.size());
        IntermediateModel fullModel = new IntermediateModel(AddMetadata.constructMetadata(this.service, this.customConfig), operations, shapes, this.customConfig, this.examples, endpointOperation, authorizers, this.paginators.getPaginators(), this.namingStrategy);
        customization.postprocess(fullModel);
        log.info("{} shapes remained after applying customizations.", (Object)fullModel.getShapes().size());
        Map<String, ShapeModel> trimmedShapes = RemoveUnusedShapes.removeUnusedShapes(fullModel);
        trimmedShapes.entrySet().removeIf(e -> this.customConfig.getDeprecatedShapes().contains(e.getKey()));
        log.info("{} shapes remained after removing unused shapes.", (Object)trimmedShapes.size());
        IntermediateModel trimmedModel = new IntermediateModel(fullModel.getMetadata(), fullModel.getOperations(), trimmedShapes, fullModel.getCustomizationConfig(), fullModel.getExamples(), endpointOperation, fullModel.getCustomAuthorizers(), fullModel.getPaginators(), this.namingStrategy);
        this.linkMembersToShapes(trimmedModel);
        this.linkOperationsToInputOutputShapes(trimmedModel);
        this.linkCustomAuthorizationToRequestShapes(trimmedModel);
        this.setSimpleMethods(trimmedModel);
        return trimmedModel;
    }

    private void linkMembersToShapes(IntermediateModel model) {
        for (Map.Entry<String, ShapeModel> entry : model.getShapes().entrySet()) {
            if (entry.getValue().getMembers() == null) continue;
            for (MemberModel member : entry.getValue().getMembers()) {
                member.setShape(Utils.findShapeModelByC2jNameIfExists(model, member.getC2jShape()));
            }
        }
    }

    private void linkOperationsToInputOutputShapes(IntermediateModel model) {
        for (Map.Entry<String, OperationModel> entry : model.getOperations().entrySet()) {
            Operation operation = this.service.getOperations().get(entry.getKey());
            if (entry.getValue().getInput() != null) {
                entry.getValue().setInputShape(model.getShapes().get(entry.getValue().getInput().getSimpleType()));
            }
            if (operation.getOutput() == null) continue;
            String outputShapeName = operation.getOutput().getShape();
            ShapeModel outputShape = model.getShapeByNameAndC2jName(entry.getValue().getReturnType().getReturnType(), outputShapeName);
            entry.getValue().setOutputShape(outputShape);
        }
    }

    private void linkCustomAuthorizationToRequestShapes(IntermediateModel model) {
        model.getOperations().values().stream().filter(OperationModel::isAuthenticated).forEach(operation -> {
            Operation c2jOperation = this.service.getOperation(operation.getOperationName());
            ShapeModel shape = operation.getInputShape();
            if (shape == null) {
                throw new RuntimeException(String.format("Operation %s has unknown input shape", operation.getOperationName()));
            }
            if (model.getMetadata().getProtocol() == Protocol.API_GATEWAY) {
                this.linkAuthorizationToRequestShapeForApiGatewayProtocol(model, c2jOperation, shape);
            } else {
                this.linkAuthorizationToRequestShapeForAwsProtocol(c2jOperation.getAuthType(), shape);
            }
        });
    }

    private void linkAuthorizationToRequestShapeForApiGatewayProtocol(IntermediateModel model, Operation c2jOperation, ShapeModel shape) {
        if (AuthType.CUSTOM.equals((Object)c2jOperation.getAuthType())) {
            AuthorizerModel auth = model.getCustomAuthorizers().get(c2jOperation.getAuthorizer());
            if (auth == null) {
                throw new RuntimeException(String.format("Required custom auth not defined: %s", c2jOperation.getAuthorizer()));
            }
            shape.setRequestSignerClassFqcn(model.getMetadata().getAuthPolicyPackageName() + '.' + auth.getInterfaceName());
        } else if (AuthType.IAM.equals((Object)c2jOperation.getAuthType())) {
            model.getMetadata().setRequiresIamSigners(true);
            shape.setRequestSignerClassFqcn("software.amazon.awssdk.opensdk.protect.auth.IamRequestSigner");
        }
    }

    private void linkAuthorizationToRequestShapeForAwsProtocol(AuthType authType, ShapeModel shape) {
        switch (authType) {
            case V4: {
                shape.setRequestSignerClassFqcn("software.amazon.awssdk.auth.signer.Aws4Signer");
                break;
            }
            case V4_UNSIGNED_BODY: {
                shape.setRequestSignerClassFqcn("software.amazon.awssdk.auth.signer.Aws4UnsignedPayloadSigner");
                break;
            }
            case NONE: 
            case IAM: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authtype for AWS Request: " + (Object)((Object)authType));
            }
        }
    }

    private void setSimpleMethods(IntermediateModel model) {
        CustomizationConfig config = model.getCustomizationConfig();
        model.getOperations().values().forEach(operation -> {
            ShapeModel inputShape = operation.getInputShape();
            String methodName = operation.getMethodName();
            if (config.getVerifiedSimpleMethods().contains(methodName)) {
                inputShape.setSimpleMethod(true);
            } else {
                inputShape.setSimpleMethod(false);
                boolean methodIsNotBlacklisted = !config.getBlacklistedSimpleMethods().contains(methodName) || config.getBlacklistedSimpleMethods().stream().noneMatch(m -> m.equals("*"));
                boolean methodHasNoRequiredMembers = !CollectionUtils.isNullOrEmpty(inputShape.getRequired());
                boolean methodIsNotStreaming = !operation.isStreaming();
                boolean methodHasSimpleMethodVerb = methodName.matches("(get|list|describe|lookup|batchGet).*");
                if (methodIsNotBlacklisted && methodHasNoRequiredMembers && methodIsNotStreaming && methodHasSimpleMethodVerb) {
                    log.warn("A potential simple method exists that isn't whitelisted or blacklisted: " + methodName);
                }
            }
        });
    }

    public CustomizationConfig getCustomConfig() {
        return this.customConfig;
    }

    public ServiceModel getService() {
        return this.service;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }

    public Paginators getPaginators() {
        return this.paginators;
    }
}

