/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

class MemberCopierSpec
implements ClassSpec {
    private final MemberModel memberModel;
    private final ServiceModelCopiers serviceModelCopiers;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;

    MemberCopierSpec(MemberModel memberModel, ServiceModelCopiers serviceModelCopiers, TypeProvider typeProvider, PoetExtensions poetExtensions) {
        this.memberModel = memberModel;
        this.serviceModelCopiers = serviceModelCopiers;
        this.typeProvider = typeProvider;
        this.poetExtensions = poetExtensions;
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(PoetUtils.generatedAnnotation()).addMethod(this.copyMethod());
        if (this.serviceModelCopiers.requiresBuilderCopier(this.memberModel)) {
            builder.addMethod(this.builderCopyMethod());
        }
        if (MemberCopierSpec.isEnumCopyAvailable(this.memberModel)) {
            builder.addMethod(this.enumToStringCopyMethod());
            builder.addMethod(this.stringToEnumCopyMethod());
        }
        return builder.build();
    }

    @Override
    public ClassName className() {
        return this.serviceModelCopiers.copierClassFor(this.memberModel).get();
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        if (this.memberModel.isList()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toList"));
        }
        if (this.memberModel.isMap()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toMap"));
        }
        return Collections.emptyList();
    }

    public static boolean isEnumCopyAvailable(MemberModel memberModel) {
        if (!memberModel.isMap() && !memberModel.isList()) {
            return false;
        }
        if (memberModel.isMap()) {
            MapModel mapModel = memberModel.getMapModel();
            MemberModel keyModel = mapModel.getKeyModel();
            MemberModel valueModel = mapModel.getValueModel();
            if (keyModel.getEnumType() != null || valueModel.getEnumType() != null) {
                return true;
            }
            if (valueModel.isList() || valueModel.isMap()) {
                return MemberCopierSpec.isEnumCopyAvailable(valueModel);
            }
            return false;
        }
        MemberModel element = memberModel.getListModel().getListMemberModel();
        if (element.getEnumType() != null) {
            return true;
        }
        if (element.isList() || element.isMap()) {
            return MemberCopierSpec.isEnumCopyAvailable(element);
        }
        return false;
    }

    private MethodSpec copyMethod() {
        return this.copyMethodProto().addCode(this.copyMethodBody()).build();
    }

    private MethodSpec.Builder copyMethodProto() {
        return this.copyMethodProto(this.typeProvider.parameterType(this.memberModel), this.typeProvider.fieldType(this.memberModel), this.serviceModelCopiers.copyMethodName());
    }

    private MethodSpec.Builder copyMethodProto(TypeName parameterType, TypeName returnType, String methodName) {
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(parameterType, this.memberParamName(), new Modifier[0]).returns(returnType);
    }

    private MethodSpec enumToStringCopyMethod() {
        return this.copyMethodProto(this.parameterTypeForEnumToStringCopyMethod(), this.typeProvider.fieldType(this.memberModel), this.serviceModelCopiers.enumToStringCopyMethodName()).addCode(this.enumToStringCopyMethodBody()).build();
    }

    private MethodSpec stringToEnumCopyMethod() {
        return this.copyMethodProto(this.typeProvider.parameterType(this.memberModel), this.typeProvider.enumReturnType(this.memberModel), this.serviceModelCopiers.stringToEnumCopyMethodName()).addCode(this.stringToEnumCopyMethodBody()).build();
    }

    private TypeName parameterTypeForEnumToStringCopyMethod() {
        return this.typeProvider.parameterType(this.memberModel, true);
    }

    private CodeBlock enumToStringCopyMethodBody() {
        if (this.memberModel.isList()) {
            return this.listCopyBody(EnumTransform.ENUM_TO_STRING);
        }
        if (this.memberModel.isMap()) {
            return this.mapCopyBody(EnumTransform.ENUM_TO_STRING);
        }
        return null;
    }

    private CodeBlock stringToEnumCopyMethodBody() {
        if (this.memberModel.isList()) {
            return this.listCopyBody(EnumTransform.STRING_TO_ENUM);
        }
        return this.mapCopyBody(EnumTransform.STRING_TO_ENUM);
    }

    private MethodSpec builderCopyMethod() {
        if (this.memberModel.isList()) {
            return this.builderCopyMethodForList();
        }
        if (this.memberModel.isMap()) {
            return this.builderCopyMethodForMap();
        }
        throw new UnsupportedOperationException();
    }

    private MethodSpec builderCopyMethodForMap() {
        TypeName keyType = this.typeProvider.getTypeNameForSimpleType(this.memberModel.getMapModel().getKeyModel().getVariable().getVariableType());
        ClassName valueParameter = this.poetExtensions.getModelClass(this.memberModel.getMapModel().getValueModel().getC2jShape());
        ClassName builderForParameter = valueParameter.nestedClass("Builder");
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, WildcardTypeName.subtypeOf((TypeName)builderForParameter)});
        CodeBlock code = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $N($N.entrySet().stream().collect(toMap($T::getKey, e -> e.getValue().build())))", new Object[]{this.serviceModelCopiers.copyMethodName(), this.memberParamName(), Map.Entry.class}).build();
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.builderCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel)).addCode(code).build();
    }

    private MethodSpec builderCopyMethodForList() {
        ClassName listParameter = this.poetExtensions.getModelClass(this.memberModel.getListModel().getListMemberModel().getC2jShape());
        ClassName builderForParameter = listParameter.nestedClass("Builder");
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)builderForParameter)});
        CodeBlock code = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $N($N.stream().map($T::$N).collect(toList()))", new Object[]{this.serviceModelCopiers.copyMethodName(), this.memberParamName(), builderForParameter, "build"}).build();
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.builderCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel)).addCode(code).build();
    }

    private CodeBlock copyMethodBody() {
        if (this.memberModel.isMap()) {
            return this.mapCopyBody(EnumTransform.NONE);
        }
        if (this.memberModel.isList()) {
            return this.listCopyBody(EnumTransform.NONE);
        }
        return this.modelCopyBody();
    }

    private CodeBlock listCopyBody(EnumTransform enumTransform) {
        String paramName = this.memberParamName();
        String copyName = paramName + "Copy";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (this.typeProvider.useAutoConstructLists()) {
            builder.beginControlFlow("if ($1N == null || $1N instanceof $2T)", new Object[]{this.memberParamName(), SdkAutoConstructList.class}).addStatement("return $T.getInstance()", new Object[]{DefaultSdkAutoConstructList.class}).endControlFlow();
        } else {
            builder.beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow();
        }
        Optional<ClassName> copierClass = this.serviceModelCopiers.copierClassFor(this.memberModel.getListModel().getListMemberModel());
        boolean hasCopier = copierClass.isPresent();
        TypeName copyType = enumTransform == EnumTransform.STRING_TO_ENUM ? this.typeProvider.enumReturnType(this.memberModel) : this.typeProvider.fieldType(this.memberModel);
        MemberModel elementModel = this.memberModel.getListModel().getListMemberModel();
        switch (enumTransform) {
            case STRING_TO_ENUM: {
                if (hasCopier) {
                    builder.addStatement("$T $N = $N.stream().map($T::$N).collect(toList())", new Object[]{copyType, copyName, paramName, copierClass.get(), this.serviceModelCopiers.stringToEnumCopyMethodName()});
                    break;
                }
                builder.addStatement("$T $N = $N.stream().map($T::fromValue).collect(toList())", new Object[]{copyType, copyName, paramName, this.poetExtensions.getModelClass(elementModel.getEnumType())});
                break;
            }
            case ENUM_TO_STRING: {
                if (hasCopier) {
                    builder.addStatement("$T $N = $N.stream().map($T::$N).collect(toList())", new Object[]{copyType, copyName, paramName, copierClass.get(), this.serviceModelCopiers.enumToStringCopyMethodName()});
                    break;
                }
                builder.addStatement("$T $N = $N.stream().map(Object::toString).collect(toList())", new Object[]{copyType, copyName, paramName});
                break;
            }
            case NONE: {
                if (hasCopier) {
                    builder.addStatement("$T $N = $N.stream().map($T::$N).collect(toList())", new Object[]{copyType, copyName, paramName, copierClass.get(), this.serviceModelCopiers.copyMethodName()});
                    break;
                }
                builder.addStatement("$T $N = new $T<>($N)", new Object[]{copyType, copyName, this.typeProvider.listImplClassName(), paramName});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown enum transform: " + (Object)((Object)enumTransform));
            }
        }
        builder.addStatement("return $T.unmodifiableList($N)", new Object[]{Collections.class, copyName});
        return builder.build();
    }

    private CodeBlock mapCopyBody(EnumTransform enumTransform) {
        MapModel mapModel = this.memberModel.getMapModel();
        String paramName = this.memberParamName();
        String copyName = paramName + "Copy";
        MemberModel keyModel = mapModel.getKeyModel();
        MemberModel valueModel = mapModel.getValueModel();
        boolean keyHasEnum = keyModel.getEnumType() != null || MemberCopierSpec.isEnumCopyAvailable(keyModel);
        boolean valueHasEnum = valueModel.getEnumType() != null || MemberCopierSpec.isEnumCopyAvailable(valueModel);
        EnumTransform keyTransform = keyHasEnum ? enumTransform : EnumTransform.NONE;
        EnumTransform valueTransform = valueHasEnum ? enumTransform : EnumTransform.NONE;
        CodeBlock keyCopyExpr = this.mapKeyValCopyExpr(keyModel, "getKey", keyTransform);
        CodeBlock valueCopyExpr = this.mapKeyValCopyExpr(valueModel, "getValue", valueTransform);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (this.typeProvider.useAutoConstructMaps()) {
            builder.beginControlFlow("if ($1N == null || $1N instanceof $2T)", new Object[]{this.memberParamName(), SdkAutoConstructMap.class}).addStatement("return $T.getInstance()", new Object[]{DefaultSdkAutoConstructMap.class}).endControlFlow();
        } else {
            builder.beginControlFlow("if ($1N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow();
        }
        TypeName copyType = enumTransform == EnumTransform.STRING_TO_ENUM ? this.typeProvider.enumReturnType(this.memberModel) : this.typeProvider.fieldType(this.memberModel);
        if (keyTransform == EnumTransform.STRING_TO_ENUM) {
            ClassName enumClassName = this.poetExtensions.getModelClass(keyModel.getEnumType());
            CodeBlock putLambda = CodeBlock.builder().beginControlFlow("(m, e) ->", new Object[0]).add("$T keyAsEnum = $L;", new Object[]{enumClassName, keyCopyExpr}).beginControlFlow("if (keyAsEnum != $T.UNKNOWN_TO_SDK_VERSION)", new Object[]{enumClassName}).add("m.put(keyAsEnum, $L);", new Object[]{valueCopyExpr}).endControlFlow().endControlFlow().build();
            builder.addStatement("$T $N = $N.entrySet().stream().collect($T::new, $L, $T::putAll)", new Object[]{copyType, copyName, this.memberParamName(), HashMap.class, putLambda, HashMap.class});
        } else {
            builder.addStatement("$T $N = $N.entrySet().stream().collect($T::new, (m, e) -> m.put($L, $L), $T::putAll)", new Object[]{copyType, copyName, this.memberParamName(), HashMap.class, keyCopyExpr, valueCopyExpr, HashMap.class});
        }
        return builder.addStatement("return $T.unmodifiableMap($N)", new Object[]{Collections.class, copyName}).build();
    }

    private CodeBlock mapKeyValCopyExpr(MemberModel keyValModel, String getterName, EnumTransform enumTransform) {
        Optional<ClassName> keyCopier = this.serviceModelCopiers.copierClassFor(keyValModel);
        boolean hasCopier = keyCopier.isPresent();
        switch (enumTransform) {
            case STRING_TO_ENUM: {
                if (hasCopier) {
                    return CodeBlock.of((String)"$T.$N(e.$N())", (Object[])new Object[]{keyCopier.get(), this.serviceModelCopiers.stringToEnumCopyMethodName(), getterName});
                }
                return CodeBlock.of((String)"$T.fromValue(e.$N())", (Object[])new Object[]{this.poetExtensions.getModelClass(keyValModel.getEnumType()), getterName});
            }
            case ENUM_TO_STRING: {
                if (hasCopier) {
                    return CodeBlock.of((String)"$T.$N(e.$N())", (Object[])new Object[]{keyCopier.get(), this.serviceModelCopiers.enumToStringCopyMethodName(), getterName});
                }
                return CodeBlock.of((String)"e.$N().toString()", (Object[])new Object[]{getterName});
            }
            case NONE: {
                if (hasCopier) {
                    return CodeBlock.of((String)"$T.$N(e.$N())", (Object[])new Object[]{keyCopier.get(), this.serviceModelCopiers.copyMethodName(), getterName});
                }
                return CodeBlock.of((String)"e.$N()", (Object[])new Object[]{getterName});
            }
        }
        throw new IllegalArgumentException("Unknown enum transform: " + (Object)((Object)enumTransform));
    }

    private CodeBlock modelCopyBody() {
        return CodeBlock.builder().addStatement("return $N", new Object[]{this.memberParamName()}).build();
    }

    private String memberParamName() {
        if (this.memberModel.isSimple()) {
            return Utils.unCapitalize(this.memberModel.getVariable().getSimpleType()) + "Param";
        }
        return Utils.unCapitalize(this.memberModel.getC2jShape()) + "Param";
    }

    private static enum EnumTransform {
        STRING_TO_ENUM,
        ENUM_TO_STRING,
        NONE;

    }
}

