/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.docs.ClientType;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.auth.DefaultCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseBytes;
import software.amazon.awssdk.core.sync.ResponseInputStream;
import software.amazon.awssdk.core.sync.StreamingResponseHandler;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public final class SyncClientInterface
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName className;
    private final String clientPackageName;
    private final PoetExtensions poetExtensions;

    public SyncClientInterface(IntermediateModel model) {
        this.model = model;
        this.clientPackageName = model.getMetadata().getFullClientPackageName();
        this.className = ClassName.get((String)this.clientPackageName, (String)model.getMetadata().getSyncInterface(), (String[])new String[0]);
        this.poetExtensions = new PoetExtensions(model);
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createInterfaceBuilder(this.className).addSuperinterface(SdkClient.class).addSuperinterface(SdkAutoCloseable.class).addJavadoc(this.getJavadoc(), new Object[0]).addField(FieldSpec.builder(String.class, (String)"SERVICE_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.model.getMetadata().getSigningName()}).build()).addMethod(this.create()).addMethod(this.builder()).addMethods(this.operations()).addMethod(this.serviceMetadata()).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private String getJavadoc() {
        return "Service client for accessing " + this.model.getMetadata().getServiceAbbreviation() + ". This can be created using the static {@link #builder()} method.\n\n" + this.model.getMetadata().getDocumentation();
    }

    private MethodSpec create() {
        return MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a {@link $T} with the region loaded from the {@link $T} and credentials loaded from the {@link $T}.", new Object[]{this.className, DefaultAwsRegionProviderChain.class, DefaultCredentialsProvider.class}).addStatement("return builder().build()", new Object[0]).build();
    }

    private MethodSpec builder() {
        ClassName builderClass = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]);
        ClassName builderInterface = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"builder").returns((TypeName)builderInterface).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a builder that can be used to configure and create a {@link $T}.", new Object[]{this.className}).addStatement("return new $T()", new Object[]{builderClass}).build();
    }

    private Iterable<MethodSpec> operations() {
        return this.model.getOperations().values().stream().map(this::operationMethodSpec).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private MethodSpec serviceMetadata() {
        return MethodSpec.methodBuilder((String)"serviceMetadata").returns(ServiceMetadata.class).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addStatement("return $T.of($S)", new Object[]{ServiceMetadata.class, this.model.getMetadata().getEndpointPrefix()}).build();
    }

    private List<MethodSpec> operationMethodSpec(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        if (opModel.getInputShape().isSimpleMethod()) {
            methods.add(this.simpleMethod(opModel));
        }
        methods.add(SyncClientInterface.operationMethodSignature(this.model, opModel).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).build());
        if (!opModel.isStreaming()) {
            methods.add(this.operationBuilderConsumer(this.model, opModel));
        }
        methods.addAll(this.streamingSimpleMethods(opModel));
        methods.addAll(this.paginatedMethods(opModel));
        return methods;
    }

    private MethodSpec operationBuilderConsumer(IntermediateModel model, OperationModel opModel) {
        ClassName requestType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ClassName builder = requestType.nestedClass("Builder");
        ParameterizedTypeName consumer = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{builder});
        return SyncClientInterface.operationBaseSignature(model, opModel, arg_0 -> SyncClientInterface.lambda$operationBuilderConsumer$0((TypeName)consumer, opModel, arg_0)).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("return $L($T.builder().apply($L).build())", new Object[]{opModel.getMethodName(), requestType, opModel.getInput().getVariableName()}).build();
    }

    private MethodSpec simpleMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.operationSimpleMethodSignature(this.model, opModel, opModel.getMethodName()).addStatement("return $L($T.builder().build())", new Object[]{opModel.getMethodName(), requestType}).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.NO_ARG), new Object[0]).build();
    }

    private static MethodSpec.Builder operationBaseSignature(IntermediateModel model, OperationModel opModel, Consumer<MethodSpec.Builder> addFirstParameter) {
        return SyncClientInterface.operationBaseSignature(model, opModel, addFirstParameter, SimpleMethodOverload.NORMAL, opModel.getMethodName());
    }

    private static MethodSpec.Builder operationBaseSignature(IntermediateModel model, OperationModel opModel, Consumer<MethodSpec.Builder> addFirstParameter, SimpleMethodOverload simpleMethodOverload, String methodName) {
        ClassName responseType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        TypeVariableName returnType = opModel.hasStreamingOutput() ? AsyncClientInterface.STREAMING_TYPE_VARIABLE : responseType;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(opModel.getDocs(model, ClientType.SYNC, simpleMethodOverload), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(model, opModel));
        addFirstParameter.accept(methodBuilder);
        SyncClientInterface.streamingMethod(methodBuilder, opModel, (TypeName)responseType);
        return methodBuilder;
    }

    static MethodSpec.Builder operationMethodSignature(IntermediateModel model, OperationModel opModel) {
        return SyncClientInterface.operationMethodSignature(model, opModel, SimpleMethodOverload.NORMAL, opModel.getMethodName());
    }

    static MethodSpec.Builder operationMethodSignature(IntermediateModel model, OperationModel opModel, SimpleMethodOverload simpleMethodOverload, String methodName) {
        ClassName requestType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return SyncClientInterface.operationBaseSignature(model, opModel, b -> b.addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]), simpleMethodOverload, methodName);
    }

    private MethodSpec.Builder operationSimpleMethodSignature(IntermediateModel model, OperationModel opModel, String methodName) {
        ClassName returnType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)methodName).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.DEFAULT}).addExceptions(SyncClientInterface.getExceptionClasses(model, opModel));
    }

    private List<MethodSpec> paginatedMethods(OperationModel opModel) {
        ArrayList<MethodSpec> paginatedMethodSpecs = new ArrayList<MethodSpec>();
        if (opModel.isPaginated()) {
            if (opModel.getInputShape().isSimpleMethod()) {
                paginatedMethodSpecs.add(this.paginatedSimpleMethod(opModel));
            }
            paginatedMethodSpecs.add(SyncClientInterface.operationMethodSignature(this.model, opModel, SimpleMethodOverload.PAGINATED, PaginatorUtils.getSyncMethodName(opModel.getMethodName())).returns((TypeName)this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName())).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).build());
        }
        return paginatedMethodSpecs;
    }

    private MethodSpec paginatedSimpleMethod(OperationModel opModel) {
        String paginatedMethodName = PaginatorUtils.getSyncMethodName(opModel.getMethodName());
        ClassName requestType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.operationSimpleMethodSignature(this.model, opModel, paginatedMethodName).returns((TypeName)this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName())).addStatement("return $L($T.builder().build())", new Object[]{paginatedMethodName, requestType}).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.NO_ARG_PAGINATED), new Object[0]).build();
    }

    private static void streamingMethod(MethodSpec.Builder methodBuilder, OperationModel opModel, TypeName responseType) {
        if (opModel.hasStreamingInput()) {
            methodBuilder.addParameter((TypeName)ClassName.get(RequestBody.class), "requestBody", new Modifier[0]);
        }
        if (opModel.hasStreamingOutput()) {
            methodBuilder.addTypeVariable(AsyncClientInterface.STREAMING_TYPE_VARIABLE);
            ParameterizedTypeName streamingResponseHandlerType = ParameterizedTypeName.get((ClassName)ClassName.get(StreamingResponseHandler.class), (TypeName[])new TypeName[]{responseType, AsyncClientInterface.STREAMING_TYPE_VARIABLE});
            methodBuilder.addParameter((TypeName)streamingResponseHandlerType, "streamingResponseHandler", new Modifier[0]);
        }
    }

    private List<MethodSpec> streamingSimpleMethods(OperationModel opModel) {
        ClassName responseType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        ClassName requestType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ArrayList<MethodSpec> simpleMethods = new ArrayList<MethodSpec>();
        if (opModel.hasStreamingInput()) {
            simpleMethods.add(this.uploadFromFileSimpleMethod(opModel, (TypeName)responseType, requestType));
        }
        if (opModel.hasStreamingOutput()) {
            simpleMethods.add(this.downloadToFileSimpleMethod(opModel, (TypeName)responseType, requestType));
            simpleMethods.add(this.inputStreamSimpleMethod(opModel, (TypeName)responseType, requestType));
            simpleMethods.add(this.bytesSimpleMethod(opModel, (TypeName)responseType, requestType));
        }
        return simpleMethods;
    }

    private MethodSpec uploadFromFileSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        return MethodSpec.methodBuilder((String)opModel.getMethodName()).returns(responseType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "filePath", new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.FILE), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($L, $T.of($L))", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(RequestBody.class), "filePath"}).build();
    }

    private MethodSpec inputStreamSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(ResponseInputStream.class), (TypeName[])new TypeName[]{responseType});
        return MethodSpec.methodBuilder((String)opModel.getMethodName()).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.INPUT_STREAM), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($L, $T.toInputStream())", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(StreamingResponseHandler.class)}).build();
    }

    private MethodSpec bytesSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(ResponseBytes.class), (TypeName[])new TypeName[]{responseType});
        return MethodSpec.methodBuilder((String)(opModel.getMethodName() + "Bytes")).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.BYTES), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($L, $T.toBytes())", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(StreamingResponseHandler.class)}).build();
    }

    private MethodSpec downloadToFileSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        return MethodSpec.methodBuilder((String)opModel.getMethodName()).returns(responseType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "filePath", new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.FILE), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($L, $T.toFile($L))", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(StreamingResponseHandler.class), "filePath"}).build();
    }

    private static List<ClassName> getExceptionClasses(IntermediateModel model, OperationModel opModel) {
        List exceptions = opModel.getExceptions().stream().map(e -> ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)e.getExceptionName(), (String[])new String[0])).collect(Collectors.toCollection(ArrayList::new));
        Collections.addAll(exceptions, ClassName.get(SdkServiceException.class), ClassName.get(SdkClientException.class), ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]));
        return exceptions;
    }

    private static /* synthetic */ void lambda$operationBuilderConsumer$0(TypeName consumer, OperationModel opModel, MethodSpec.Builder b) {
        b.addParameter(consumer, opModel.getInput().getVariableName(), new Modifier[0]);
    }
}

