/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.BeanGetterHelper;
import software.amazon.awssdk.codegen.poet.model.ListSetters;
import software.amazon.awssdk.codegen.poet.model.MapSetters;
import software.amazon.awssdk.codegen.poet.model.NonCollectionSetters;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class AccessorsFactory {
    private final ShapeModel shapeModel;
    private final TypeProvider typeProvider;
    private final IntermediateModel intermediateModel;
    private final BeanGetterHelper getterHelper;

    AccessorsFactory(ShapeModel shapeModel, IntermediateModel intermediateModel, TypeProvider typeProvider, PoetExtensions poetExtensions) {
        this.shapeModel = shapeModel;
        this.typeProvider = typeProvider;
        this.intermediateModel = intermediateModel;
        this.getterHelper = new BeanGetterHelper(poetExtensions, typeProvider);
    }

    public MethodSpec beanStyleGetter(MemberModel memberModel) {
        return this.getterHelper.beanStyleGetter(memberModel);
    }

    public List<MethodSpec> fluentSetterDeclarations(MemberModel memberModel, TypeName returnType) {
        if (memberModel.isList()) {
            return new ListSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluentDeclarations(returnType);
        }
        if (memberModel.isMap()) {
            return new MapSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluentDeclarations(returnType);
        }
        return new NonCollectionSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluentDeclarations(returnType);
    }

    public List<MethodSpec> fluentSetters(MemberModel memberModel, TypeName returnType) {
        if (memberModel.isList()) {
            return new ListSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluent(returnType);
        }
        if (memberModel.isMap()) {
            return new MapSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluent(returnType);
        }
        return new NonCollectionSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).fluent(returnType);
    }

    public MethodSpec beanStyleSetter(MemberModel memberModel) {
        if (memberModel.isList()) {
            return new ListSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).beanStyle();
        }
        if (memberModel.isMap()) {
            return new MapSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).beanStyle();
        }
        return new NonCollectionSetters(this.intermediateModel, this.shapeModel, memberModel, this.typeProvider).beanStyle();
    }
}

