/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import java.util.Map;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.docs.Factory;
import software.amazon.awssdk.codegen.docs.OperationDocProvider;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.core.util.ImmutableMapParameter;

class AsyncOperationDocProvider
extends OperationDocProvider {
    private static final String REQUEST_PROVIDER_DOCS = "Functional interface that can be implemented to produce the request content in a non-blocking manner. The size of the content is expected to be known up front. See {@link AsyncRequestProvider} for specific details on implementing this interface as well as links to precanned implementations for common scenarios like uploading from a file. ";
    private static final String STREAM_RESPONSE_HANDLER_DOCS = "The response handler for processing the streaming response in a non-blocking manner. See {@link AsyncResponseHandler} for details on how this callback should be implemented and for links to precanned implementations for common scenarios like downloading to a file. ";

    private AsyncOperationDocProvider(IntermediateModel model, OperationModel opModel) {
        super(model, opModel);
    }

    @Override
    protected String getDefaultServiceDocs() {
        return String.format("Invokes the %s operation asynchronously.", this.opModel.getOperationName());
    }

    @Override
    protected String getInterfaceName() {
        return this.model.getMetadata().getAsyncInterface();
    }

    @Override
    protected void applyReturns(DocumentationBuilder docBuilder) {
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.returns("A future to the transformed result of the AsyncResponseHandler.");
        } else {
            docBuilder.returns("A Java Future containing the result of the %s operation returned by the service.", this.opModel.getOperationName());
        }
    }

    @Override
    protected void applyParams(DocumentationBuilder docBuilder) {
        this.emitRequestParm(docBuilder);
        if (this.opModel.hasStreamingInput()) {
            docBuilder.param("requestProvider", REQUEST_PROVIDER_DOCS + this.getStreamingInputDocs());
        }
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.param("asyncResponseHandler", STREAM_RESPONSE_HANDLER_DOCS + this.getStreamingOutputDocs());
        }
    }

    @Override
    protected void applyThrows(DocumentationBuilder docBuilder) {
        docBuilder.asyncThrows(this.getThrows());
    }

    static Map<SimpleMethodOverload, Factory> asyncFactories() {
        return ImmutableMapParameter.of((Object)((Object)SimpleMethodOverload.NORMAL), AsyncOperationDocProvider::new, (Object)((Object)SimpleMethodOverload.NO_ARG), (x$0, x$1) -> new AsyncNoArg((IntermediateModel)x$0, (OperationModel)x$1), (Object)((Object)SimpleMethodOverload.FILE), (x$0, x$1) -> new AsyncFile((IntermediateModel)x$0, (OperationModel)x$1));
    }

    private static class AsyncNoArg
    extends AsyncOperationDocProvider {
        private AsyncNoArg(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
        }
    }

    private static class AsyncFile
    extends AsyncOperationDocProvider {
        private AsyncFile(IntermediateModel model, OperationModel opModel) {
            super(model, opModel);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
            if (this.opModel.hasStreamingInput()) {
                docBuilder.param("path", "{@link Path} to file containing data to send to the service. File will be read entirely and may be read multiple times in the event of a retry. If the file does not exist or the current user does not have access to read it then an exception will be thrown. " + this.getStreamingInputDocs());
            }
            if (this.opModel.hasStreamingOutput()) {
                docBuilder.param("path", "{@link Path} to file that response contents will be written to. The file must not exist or this method will throw an exception. If the file is not writable by the current user then an exception will be thrown. " + this.getStreamingOutputDocs());
            }
        }
    }
}

