/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.concurrent.Executor;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientClass;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

public final class AsyncClientClass
extends AsyncClientInterface {
    private final IntermediateModel model;
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;

    public AsyncClientClass(GeneratorTaskParams dependencies) {
        super(dependencies.getModel());
        this.model = dependencies.getModel();
        this.poetExtensions = dependencies.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model.getMetadata().getProtocol());
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
        TypeSpec.Builder classBuilder = PoetUtils.createClassBuilder(this.className);
        classBuilder.addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addField(FieldSpec.builder((TypeName)ClassName.get(Logger.class), (String)"log", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.getLogger($T.class)", new Object[]{LoggerFactory.class, this.className}).build()).addField(AsyncClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass}).addMethod(this.constructor(classBuilder)).addMethod(this.nameMethod()).addMethods(this.operations()).addMethod(this.closeMethod()).addMethods(this.protocolSpec.additionalMethods()).addMethod(this.protocolSpec.initProtocolFactory(this.model));
        if (this.model.getMetadata().isCborProtocol()) {
            classBuilder.addField(AwsJsonProtocolFactory.class, "jsonProtocolFactory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        }
        if (this.model.hasPaginators()) {
            classBuilder.addMethod(ClientClassUtils.applyPaginatorUserAgentMethod(this.poetExtensions, this.model));
        }
        if (this.model.containsRequestSigners()) {
            classBuilder.addMethod(ClientClassUtils.applySignerOverrideMethod(this.poetExtensions, this.model));
        }
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        return classBuilder.build();
    }

    private MethodSpec constructor(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SdkClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration)", new Object[]{AwsAsyncClientHandler.class});
        if (this.model.getMetadata().isJsonProtocol()) {
            builder.addStatement("this.$N = init($L)", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name, this.model.getMetadata().isCborProtocol()});
        } else {
            builder.addStatement("this.$N = init()", new Object[]{this.protocolSpec.protocolFactory((IntermediateModel)this.model).name});
        }
        if (this.model.getMetadata().isCborProtocol()) {
            builder.addStatement("this.jsonProtocolFactory = init(false)", new Object[0]);
        }
        if (this.hasOperationWithEventStreamOutput()) {
            classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(Executor.class), (String)"executor", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builder.addStatement("this.executor = clientConfiguration.option($T.FUTURE_COMPLETION_EXECUTOR)", new Object[]{SdkAdvancedAsyncClientOption.class});
        }
        return builder.build();
    }

    private boolean hasOperationWithEventStreamOutput() {
        return this.model.getOperations().values().stream().anyMatch(OperationModel::hasEventStreamOutput);
    }

    private MethodSpec nameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return SERVICE_NAME", new Object[0]).build();
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$N.close()", new Object[]{"clientHandler"}).build();
    }

    @Override
    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).beginControlFlow("try", new Object[0]).addCode(ClientClassUtils.callApplySignerOverrideMethod(opModel)).addCode(ClientClassUtils.getCustomResponseHandler(opModel, returnType).orElseGet(() -> this.protocolSpec.responseHandler(this.model, opModel))).addCode(this.protocolSpec.errorResponseHandler(opModel)).addCode(this.protocolSpec.asyncExecutionHandler(opModel)).endControlFlow().beginControlFlow("catch ($T t)", new Object[]{Throwable.class});
        if (opModel.hasStreamingOutput() || opModel.hasEventStreamOutput()) {
            String paramName = opModel.hasStreamingOutput() ? "asyncResponseTransformer" : "asyncResponseHandler";
            builder.addStatement("runAndLogError(log, \"Exception thrown in exceptionOccurred callback, ignoring\",\n() -> $L.exceptionOccurred(t))", new Object[]{paramName});
        }
        return builder.addStatement("return $T.failedFuture(t)", new Object[]{CompletableFutureUtils.class}).endControlFlow();
    }

    @Override
    protected MethodSpec.Builder paginatedMethodBody(MethodSpec.Builder builder, OperationModel opModel) {
        return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new $T(this, applyPaginatorUserAgent($L))", new Object[]{this.poetExtensions.getResponseClassForPaginatedAsyncOperation(opModel.getOperationName()), opModel.getInput().getVariableName()});
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        return Collections.singletonList(StaticImport.staticMethodImport(FunctionalUtils.class, "runAndLogError"));
    }
}

