/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;

public class JsonProtocolSpec
implements ProtocolSpec {
    private final PoetExtensions poetExtensions;

    public JsonProtocolSpec(PoetExtensions poetExtensions) {
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder(AwsJsonProtocolFactory.class, (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        String exceptionPath = model.getSdkModeledExceptionBaseFqcn().substring(0, model.getSdkModeledExceptionBaseFqcn().lastIndexOf("."));
        ClassName baseException = ClassName.get((String)exceptionPath, (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]);
        Metadata metadata = model.getMetadata();
        ClassName protocolFactory = this.poetExtensions.getClientClass(metadata.getProtocolFactory());
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").returns((TypeName)protocolFactory).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("return new $T(new $T()\n.withSupportsCbor($L)\n.withSupportsIon($L).withBaseServiceExceptionClass($L.class)", new Object[]{AwsJsonProtocolFactory.class, JsonClientMetadata.class, metadata.isCborProtocol(), metadata.isIonProtocol(), baseException});
        if (metadata.getContentType() != null) {
            methodSpec.addCode(".withContentTypeOverride($S)", new Object[]{metadata.getContentType()});
        }
        this.errorUnmarshallers(model).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(",\n", new Object[0]);
        methodSpec.addCode("$T.builder().protocolVersion($S)\n.protocol($T.$L).build()", new Object[]{AwsJsonProtocolMetadata.class, metadata.getJsonVersion(), AwsJsonProtocol.class, this.protocolEnumName(metadata.getProtocol())});
        methodSpec.addCode(");", new Object[0]);
        return methodSpec.build();
    }

    @Override
    public CodeBlock responseHandler(OperationModel opModel) {
        ClassName unmarshaller = this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return CodeBlock.builder().add("\n\n$T<$T> responseHandler = $L.createResponseHandler(new $T()                                   .withPayloadJson($L)                                   .withHasStreamingSuccessResponse($L), new $T());", new Object[]{HttpResponseHandler.class, returnType, "protocolFactory", JsonOperationMetadata.class, !opModel.getHasBlobMemberAsPayload(), opModel.hasStreamingOutput(), unmarshaller}).build();
    }

    @Override
    public CodeBlock errorResponseHandler(OperationModel opModel) {
        return CodeBlock.builder().add("\n\n$T<$T> errorResponseHandler = createErrorResponseHandler();", new Object[]{HttpResponseHandler.class, AwsServiceException.class}).build();
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withResponseHandler($N)\n.withErrorResponseHandler($N)\n.withInput($L)\n", new Object[]{ClientExecutionParams.class, requestType, responseType, "responseHandler", "errorResponseHandler", opModel.getInput().getVariableName()});
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withMarshaller(new $T(new $T(protocolFactory), requestBody)));", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(StreamingRequestMarshaller.class), (TypeName[])new TypeName[]{requestType}), marshaller}).build();
        }
        return codeBlock.add(".withMarshaller(new $T(protocolFactory))$L);", new Object[]{marshaller, opModel.hasStreamingOutput() ? ", responseTransformer" : ""}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(OperationModel opModel) {
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestBody = opModel.hasStreamingInput() ? ".withAsyncRequestBody(requestBody)" : "";
        return CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withMarshaller(new $T(protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)\n" + asyncRequestBody + ".withInput($L)$L);", new Object[]{ClientExecutionParams.class, requestType, pojoResponseType, marshaller, opModel.getInput().getVariableName(), opModel.hasStreamingOutput() ? ", asyncResponseTransformer" : ""}).build();
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        ClassName httpResponseHandler = ClassName.get(HttpResponseHandler.class);
        ClassName sdkBaseException = ClassName.get(AwsServiceException.class);
        ParameterizedTypeName responseHandlerOfException = ParameterizedTypeName.get((ClassName)httpResponseHandler, (TypeName[])new TypeName[]{sdkBaseException});
        return Optional.of(MethodSpec.methodBuilder((String)"createErrorResponseHandler").returns((TypeName)responseHandlerOfException).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return protocolFactory.createErrorResponseHandler(new $T())", new Object[]{JsonErrorResponseMetadata.class}).build());
    }

    @Override
    public List<CodeBlock> errorUnmarshallers(IntermediateModel model) {
        List exceptions = model.getShapes().values().stream().filter(s -> s.getShapeType().equals((Object)ShapeType.Exception)).collect(Collectors.toList());
        return exceptions.stream().map(s -> {
            ClassName exceptionClass = this.poetExtensions.getModelClass(s.getShapeName());
            return CodeBlock.builder().add(".addErrorMetadata(new $T().withErrorCode($S).withModeledClass($T.class))", new Object[]{JsonErrorShapeMetadata.class, s.getErrorCode(), exceptionClass}).build();
        }).collect(Collectors.toList());
    }

    private String protocolEnumName(Protocol protocol) {
        switch (protocol) {
            case CBOR: 
            case ION: 
            case AWS_JSON: {
                return Protocol.AWS_JSON.name();
            }
        }
        return protocol.name();
    }
}

