/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.AccessorsFactory;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseRequestSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseResponseSpec;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.utils.builder.CopyableBuilder;

class ModelBuilderSpecs {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final ShapeModelSpec shapeModelSpec;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;
    private final AccessorsFactory accessorsFactory;

    ModelBuilderSpecs(IntermediateModel intermediateModel, ShapeModel shapeModel, ShapeModelSpec shapeModelSpec, TypeProvider typeProvider) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.shapeModelSpec = shapeModelSpec;
        this.typeProvider = typeProvider;
        this.poetExtensions = new PoetExtensions(this.intermediateModel);
        this.accessorsFactory = new AccessorsFactory(this.shapeModel, this.intermediateModel, this.typeProvider, this.poetExtensions);
    }

    public ClassName builderInterfaceName() {
        return this.classToBuild().nestedClass("Builder");
    }

    public ClassName builderImplName() {
        return this.classToBuild().nestedClass("BuilderImpl");
    }

    public TypeSpec builderInterface() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)this.builderInterfaceName()).addSuperinterfaces(this.builderSuperInterfaces()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            builder.addMethods(this.accessorsFactory.fluentSetterDeclarations((MemberModel)m, (TypeName)this.builderInterfaceName()));
            builder.addMethods(this.accessorsFactory.convenienceSetterDeclarations((MemberModel)m, (TypeName)this.builderInterfaceName()));
        });
        if (this.isException()) {
            builder.addMethod(MethodSpec.methodBuilder((String)"message").returns((TypeName)this.builderInterfaceName()).addParameter(String.class, "message", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        }
        if (this.isRequest()) {
            builder.addMethod(MethodSpec.methodBuilder((String)"requestOverrideConfig").returns((TypeName)this.builderInterfaceName()).addAnnotation(Override.class).addParameter(AwsRequestOverrideConfig.class, "awsRequestOverrideConfig", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"requestOverrideConfig").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{AwsRequestOverrideConfig.Builder.class}), "builderConsumer", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        }
        return builder.build();
    }

    public TypeSpec beanStyleBuilder() {
        TypeSpec.Builder builderClassBuilder = TypeSpec.classBuilder((ClassName)this.builderImplName()).addSuperinterface((TypeName)this.builderInterfaceName()).superclass(this.builderImplSuperClass()).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL});
        builderClassBuilder.addFields(this.fields());
        builderClassBuilder.addMethod(this.noargConstructor());
        builderClassBuilder.addMethod(this.modelCopyConstructor());
        builderClassBuilder.addMethods(this.accessors());
        builderClassBuilder.addMethod(this.buildMethod());
        return builderClassBuilder.build();
    }

    private TypeName builderImplSuperClass() {
        if (this.isRequest()) {
            return new AwsServiceBaseRequestSpec(this.intermediateModel).className().nestedClass("BuilderImpl");
        }
        if (this.isResponse()) {
            return new AwsServiceBaseResponseSpec(this.intermediateModel).className().nestedClass("BuilderImpl");
        }
        return ClassName.OBJECT;
    }

    private List<FieldSpec> fields() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>(this.shapeModelSpec.fields(Modifier.PRIVATE));
        if (this.isException()) {
            fields.add(FieldSpec.builder(String.class, (String)"message", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        }
        return fields;
    }

    private MethodSpec noargConstructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        return ctorBuilder.build();
    }

    private MethodSpec modelCopyConstructor() {
        MethodSpec.Builder copyBuilderCtor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.classToBuild(), "model", new Modifier[0]);
        if (this.isRequest() || this.isResponse()) {
            copyBuilderCtor.addCode("super(model);", new Object[0]);
        }
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            String name = m.getVariable().getVariableName();
            copyBuilderCtor.addStatement("$N(model.$N)", new Object[]{m.getFluentSetterMethodName(), name});
        });
        if (this.isException()) {
            copyBuilderCtor.addStatement("this.message = model.getMessage()", new Object[0]);
        }
        return copyBuilderCtor.build();
    }

    private List<MethodSpec> accessors() {
        ArrayList<MethodSpec> accessors = new ArrayList<MethodSpec>();
        this.shapeModel.getNonStreamingMembers().stream().forEach(m -> {
            accessors.add(this.accessorsFactory.beanStyleGetter((MemberModel)m));
            accessors.addAll(this.accessorsFactory.fluentSetters((MemberModel)m, (TypeName)this.builderInterfaceName()));
            accessors.add(this.accessorsFactory.beanStyleSetter((MemberModel)m));
            accessors.addAll(this.accessorsFactory.convenienceSetters((MemberModel)m, (TypeName)this.builderInterfaceName()));
        });
        if (this.isException()) {
            accessors.addAll(this.exceptionMessageGetters());
            accessors.addAll(this.exceptionMessageSetters());
        }
        if (this.isRequest()) {
            accessors.add(MethodSpec.methodBuilder((String)"requestOverrideConfig").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter(AwsRequestOverrideConfig.class, "awsRequestOverrideConfig", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super.requestOverrideConfig(awsRequestOverrideConfig)", new Object[0]).addStatement("return this", new Object[0]).build());
            accessors.add(MethodSpec.methodBuilder((String)"requestOverrideConfig").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{AwsRequestOverrideConfig.Builder.class}), "builderConsumer", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super.requestOverrideConfig(builderConsumer)", new Object[0]).addStatement("return this", new Object[0]).build());
        }
        return accessors;
    }

    private MethodSpec buildMethod() {
        return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classToBuild()).addStatement("return new $T(this)", new Object[]{this.classToBuild()}).build();
    }

    private ClassName classToBuild() {
        return this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
    }

    private boolean isException() {
        return this.shapeModel.getShapeType() == ShapeType.Exception;
    }

    private boolean isRequest() {
        return this.shapeModel.getShapeType() == ShapeType.Request;
    }

    private boolean isResponse() {
        return this.shapeModel.getShapeType() == ShapeType.Response;
    }

    private List<TypeName> builderSuperInterfaces() {
        ArrayList<TypeName> superInterfaces = new ArrayList<TypeName>();
        if (this.isRequest()) {
            superInterfaces.add((TypeName)new AwsServiceBaseRequestSpec(this.intermediateModel).className().nestedClass("Builder"));
        }
        if (this.isResponse()) {
            superInterfaces.add((TypeName)new AwsServiceBaseResponseSpec(this.intermediateModel).className().nestedClass("Builder"));
        }
        superInterfaces.add((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CopyableBuilder.class), (TypeName[])new TypeName[]{this.classToBuild().nestedClass("Builder"), this.classToBuild()}));
        return superInterfaces;
    }

    private List<MethodSpec> exceptionMessageGetters() {
        ArrayList<MethodSpec> getters = new ArrayList<MethodSpec>();
        getters.add(MethodSpec.methodBuilder((String)"getMessage").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return message", new Object[0]).build());
        getters.add(MethodSpec.methodBuilder((String)"message").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return message", new Object[0]).build());
        return getters;
    }

    private List<MethodSpec> exceptionMessageSetters() {
        ArrayList<MethodSpec> setters = new ArrayList<MethodSpec>();
        setters.add(MethodSpec.methodBuilder((String)"setMessage").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "message", new Modifier[0]).addStatement("this.message = message", new Object[0]).build());
        setters.add(MethodSpec.methodBuilder((String)"message").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderInterfaceName()).addAnnotation(Override.class).addParameter(String.class, "message", new Modifier[0]).addStatement("this.message = message", new Object[0]).addStatement("return this", new Object[0]).build());
        return setters;
    }
}

