/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import software.amazon.awssdk.codegen.docs.DocConfiguration;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.docs.OperationDocProvider;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;

class AsyncOperationDocProvider
extends OperationDocProvider {
    private static final String REQUEST_BODY_DOCS = "Functional interface that can be implemented to produce the request content in a non-blocking manner. The size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on implementing this interface as well as links to precanned implementations for common scenarios like uploading from a file. ";
    private static final String STREAM_RESPONSE_TRANSFORMER_DOCS = "The response transformer for processing the streaming response in a non-blocking manner. See {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to precanned implementations for common scenarios like downloading to a file. ";

    AsyncOperationDocProvider(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
        super(model, opModel, configuration);
    }

    @Override
    protected String getDefaultServiceDocs() {
        return String.format("Invokes the %s operation asynchronously.", this.opModel.getOperationName());
    }

    @Override
    protected String getInterfaceName() {
        return this.model.getMetadata().getAsyncInterface();
    }

    @Override
    protected void applyReturns(DocumentationBuilder docBuilder) {
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.returns("A future to the transformed result of the AsyncResponseTransformer.");
        } else {
            docBuilder.returns("A Java Future containing the result of the %s operation returned by the service.", this.opModel.getOperationName());
        }
    }

    @Override
    protected void applyParams(DocumentationBuilder docBuilder) {
        this.emitRequestParm(docBuilder);
        if (this.opModel.hasStreamingInput()) {
            docBuilder.param("requestBody", REQUEST_BODY_DOCS + this.getStreamingInputDocs());
        }
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.param("asyncResponseTransformer", STREAM_RESPONSE_TRANSFORMER_DOCS + this.getStreamingOutputDocs());
        }
    }

    @Override
    protected void applyThrows(DocumentationBuilder docBuilder) {
        docBuilder.asyncThrows(this.getThrows());
    }

    static class AsyncPaginatedNoArg
    extends AsyncPaginated {
        AsyncPaginatedNoArg(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
        }
    }

    static class AsyncPaginated
    extends AsyncOperationDocProvider {
        AsyncPaginated(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected String appendToDescription() {
            return this.paginationDocs.getDocsForAsyncOperation();
        }

        @Override
        protected void applyReturns(DocumentationBuilder docBuilder) {
            docBuilder.returns("A custom publisher that can be subscribed to request a stream of response pages.");
        }
    }

    static class AsyncNoArg
    extends AsyncOperationDocProvider {
        AsyncNoArg(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
        }
    }

    static class AsyncFile
    extends AsyncOperationDocProvider {
        AsyncFile(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
            if (this.opModel.hasStreamingInput()) {
                docBuilder.param("path", "{@link Path} to file containing data to send to the service. File will be read entirely and may be read multiple times in the event of a retry. If the file does not exist or the current user does not have access to read it then an exception will be thrown. " + this.getStreamingInputDocs());
            }
            if (this.opModel.hasStreamingOutput()) {
                docBuilder.param("path", "{@link Path} to file that response contents will be written to. The file must not exist or this method will throw an exception. If the file is not writable by the current user then an exception will be thrown. " + this.getStreamingOutputDocs());
            }
        }
    }
}

