/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import software.amazon.awssdk.codegen.internal.Jackson;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.utils.Logger;

public class ModelLoaderUtils {
    public static final Logger log = Logger.loggerFor(ModelLoaderUtils.class);

    public static ServiceModel loadModel(String modelLocation) {
        return ModelLoaderUtils.loadConfigurationModel(ServiceModel.class, modelLocation);
    }

    public static <T> T loadConfigurationModel(Class<T> clzz, String configurationFileLocation) {
        log.info(() -> "Loading config file " + configurationFileLocation);
        InputStream fileContents = null;
        try {
            fileContents = ModelLoaderUtils.getRequiredResourceAsStream(configurationFileLocation);
            T t = Jackson.load(clzz, fileContents);
            return t;
        }
        catch (IOException e) {
            log.error(() -> "Failed to read the configuration file " + configurationFileLocation);
            throw new RuntimeException(e);
        }
        finally {
            if (fileContents != null) {
                Utils.closeQuietly(fileContents);
            }
        }
    }

    public static InputStream getRequiredResourceAsStream(String location) {
        return Utils.getRequiredResourceAsStream(ModelLoaderUtils.class, location);
    }

    public static <T> T loadModel(Class<T> clzz, File file) {
        try {
            return Jackson.load(clzz, file);
        }
        catch (IOException e) {
            log.error(() -> "Failed to read the configuration file " + file.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    public static <T> Optional<T> loadOptionalModel(Class<T> clzz, File file) {
        if (!file.exists()) {
            return Optional.empty();
        }
        return Optional.of(ModelLoaderUtils.loadModel(clzz, file));
    }
}

