/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.runtime.StandardMemberCopier;

class MemberCopierSpec
implements ClassSpec {
    private final MemberModel memberModel;
    private final ServiceModelCopiers serviceModelCopiers;
    private final TypeProvider typeProvider;

    MemberCopierSpec(MemberModel memberModel, ServiceModelCopiers serviceModelCopiers, TypeProvider typeProvider) {
        this.memberModel = memberModel;
        this.serviceModelCopiers = serviceModelCopiers;
        this.typeProvider = typeProvider;
    }

    @Override
    public TypeSpec poetSpec() {
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(PoetUtils.GENERATED).addMethod(this.copyMethod()).build();
    }

    @Override
    public ClassName className() {
        return this.serviceModelCopiers.copierClassFor(this.memberModel).get();
    }

    private MethodSpec copyMethod() {
        return this.copyMethodProto().addCode(this.copyMethodBody()).build();
    }

    private MethodSpec.Builder copyMethodProto() {
        TypeName parameterType = this.typeProvider.parameterType(this.memberModel);
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.copyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(ParameterSpec.builder((TypeName)parameterType, (String)this.memberParamName(), (Modifier[])new Modifier[0]).build()).returns(this.typeProvider.fieldType(this.memberModel));
    }

    private CodeBlock copyMethodBody() {
        if (this.memberModel.isMap()) {
            return this.mapCopyBody();
        }
        if (this.memberModel.isList()) {
            return this.listCopyBody();
        }
        return this.modelCopyBody();
    }

    private CodeBlock listCopyBody() {
        String paramName = this.memberParamName();
        MemberModel listMember = this.memberModel.getListModel().getListMemberModel();
        String copyName = paramName + "Copy";
        CodeBlock.Builder builder = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T $N = new $T<>($N.size())", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, this.typeProvider.listImplClassName(), paramName}).beginControlFlow("for ($T e : $N)", new Object[]{this.typeProvider.parameterType(listMember), paramName});
        CodeBlock.Builder elementCopyExprBuilder = CodeBlock.builder();
        this.serviceModelCopiers.copierClassFor(listMember).map(copyClass -> elementCopyExprBuilder.add("$T.$N(e)", new Object[]{copyClass, this.serviceModelCopiers.copyMethodName()})).orElseGet(() -> elementCopyExprBuilder.add("e", new Object[0]));
        return builder.addStatement("$N.add($L)", new Object[]{copyName, elementCopyExprBuilder.build()}).endControlFlow().addStatement("return $N", new Object[]{copyName}).build();
    }

    private CodeBlock mapCopyBody() {
        MapModel mapModel = this.memberModel.getMapModel();
        String paramName = this.memberParamName();
        String copyName = paramName + "Copy";
        CodeBlock.Builder builder = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T $N = new $T<>($N.size())", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, this.typeProvider.mapImplClassName(), this.memberParamName()}).beginControlFlow("for ($T e : $N.entrySet())", new Object[]{this.typeProvider.mapEntryType(mapModel), paramName});
        CodeBlock keyCopyExpr = CodeBlock.of((String)"$T.$N(e.getKey())", (Object[])new Object[]{ClassName.get(StandardMemberCopier.class), this.serviceModelCopiers.copyMethodName()});
        CodeBlock.Builder valueCopyExprBuilder = CodeBlock.builder();
        this.serviceModelCopiers.copierClassFor(mapModel.getValueModel()).map(copyClass -> valueCopyExprBuilder.add("$T.$N(e.getValue())", new Object[]{copyClass, this.serviceModelCopiers.copyMethodName()})).orElseGet(() -> valueCopyExprBuilder.add("e.getValue()", new Object[0]));
        return builder.addStatement("$N.put($L, $L)", new Object[]{copyName, keyCopyExpr, valueCopyExprBuilder.build()}).endControlFlow().addStatement("return $N", new Object[]{copyName}).build();
    }

    private CodeBlock modelCopyBody() {
        return CodeBlock.builder().addStatement("return $N", new Object[]{this.memberParamName()}).build();
    }

    private String memberParamName() {
        if (this.memberModel.isSimple()) {
            return Utils.unCapitialize(this.memberModel.getVariable().getSimpleType()) + "Param";
        }
        return Utils.unCapitialize(this.memberModel.getC2jShape()) + "Param";
    }
}

