/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;

public class DocumentationUtils {
    public static final String DEFAULT_ASYNC_RETURN = "A Java Future containing the result of the %s operation returned by the service.";
    public static final String DEFAULT_SYNC_RETURN = "Result of the %s operation returned by the service.";
    public static final String DEFAULT_SETTER = "Sets the value of the %s property for this object.";
    public static final String DEFAULT_SETTER_PARAM = "The new value for the %s property for this object.";
    public static final String DEFAULT_GETTER = "Returns the value of the %s property for this object.";
    public static final String DEFAULT_GETTER_PARAM = "The value of the %s property for this object.";
    public static final String DEFAULT_FLUENT_RETURN = "Returns a reference to this object so that method calls can be chained together.";
    public static final String CONSTRUCTOR_DOC = "Constructs a new %s object. Callers should use the setter or fluent setter (with...) methods to initialize any additional object members.";
    public static final String LIST_VARARG_ADDITIONAL_DOC = "<p><b>NOTE:</b> This method appends the values to the existing list (if any). Use {@link #set%s(java.util.Collection)} or {@link #with%s(java.util.Collection)} if you want to override the existing values.</p>";
    private static final Set<String> SERVICES_EXCLUDED_FROM_CROSS_LINKING = new HashSet<String>(Arrays.asList("apigateway", "budgets", "cloudsearch", "cloudsearchdomain", "discovery", "elastictranscoder", "es", "glacier", "importexport", "iot", "data.iot", "machinelearning", "rekognition", "s3", "sdb", "swf"));

    public static String generateSetterDocumentation() {
        return null;
    }

    public static String generateGetterDocumentation() {
        return null;
    }

    public static String generateWitherDocumentation() {
        return null;
    }

    public static String stripHtmlTags(String documentation) {
        if (documentation == null) {
            return "";
        }
        if (documentation.startsWith("<")) {
            int startTagIndex = documentation.indexOf(">");
            int closingTagIndex = documentation.lastIndexOf("<");
            documentation = closingTagIndex > startTagIndex ? DocumentationUtils.stripHtmlTags(documentation.substring(startTagIndex + 1, closingTagIndex)) : DocumentationUtils.stripHtmlTags(documentation.substring(startTagIndex + 1));
        }
        return documentation.trim();
    }

    public static String escapeIllegalCharacters(String documentation) {
        if (documentation == null) {
            return "";
        }
        documentation = documentation.replaceAll("\\*\\/", "*&#47;");
        return documentation;
    }

    public static String createLinkToServiceDocumentation(Metadata metadata, String name) {
        if (DocumentationUtils.isCrossLinkingEnabledForService(metadata)) {
            return String.format("@see <a href=\"http://%s/goto/WebAPI/%s/%s\" target=\"_top\">AWS API Documentation</a>", "docs.aws.amazon.com", metadata.getUid(), name);
        }
        return "";
    }

    public static String createLinkToServiceDocumentation(Metadata metadata, ShapeModel shapeModel) {
        return DocumentationUtils.isRequestResponseOrModel(shapeModel) ? DocumentationUtils.createLinkToServiceDocumentation(metadata, shapeModel.getDocumentationShapeName()) : "";
    }

    public static String removeFromEnd(String string, String stringToRemove) {
        return string.endsWith(stringToRemove) ? string.substring(0, string.length() - stringToRemove.length()) : string;
    }

    private static boolean isRequestResponseOrModel(ShapeModel shapeModel) {
        return shapeModel.getShapeType() == ShapeType.Model || shapeModel.getShapeType() == ShapeType.Request || shapeModel.getShapeType() == ShapeType.Response;
    }

    private static boolean isCrossLinkingEnabledForService(Metadata metadata) {
        return metadata.getUid() != null && metadata.getEndpointPrefix() != null && !SERVICES_EXCLUDED_FROM_CROSS_LINKING.contains(metadata.getEndpointPrefix());
    }
}

