/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.config.ConstructorFormsWrapper;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.ArgumentModel;
import software.amazon.awssdk.codegen.model.intermediate.ConstructorModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.model.service.ServiceModel;

final class CustomConstructorsProcessor
implements CodegenCustomizationProcessor {
    private final CustomizationConfig customConfig;

    CustomConstructorsProcessor(CustomizationConfig customConfig) {
        this.customConfig = customConfig;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        Map<String, ShapeModel> javaShapes = intermediateModel.getShapes();
        this.addConstructors(javaShapes);
    }

    private void addConstructors(Map<String, ShapeModel> javaShapes) {
        Map<String, ConstructorFormsWrapper> additionalConstructors = this.customConfig.getAdditionalShapeConstructors();
        if (additionalConstructors == null) {
            return;
        }
        for (Map.Entry<String, ConstructorFormsWrapper> entry : additionalConstructors.entrySet()) {
            String shapeName = entry.getKey();
            List<List<String>> forms = entry.getValue().getConstructorForms();
            ShapeModel shapeModel = javaShapes.get(shapeName);
            if (shapeModel == null) {
                throw new RuntimeException("Not able to add constructor. No shape defined with name " + shapeName);
            }
            Map<String, MemberModel> members = shapeModel.getMembersAsMap();
            for (List<String> form : forms) {
                ConstructorModel consModel = new ConstructorModel(shapeName);
                boolean hasEnumMember = false;
                for (String argument : form) {
                    MemberModel memberModel = members.get(argument);
                    if (memberModel == null) {
                        throw new RuntimeException("Not able to add constructor. Member " + argument + " not present in shape " + shapeName);
                    }
                    if (memberModel.getVariable() == null) {
                        throw new RuntimeException("Not able to add constructor. Member " + argument + " doesnt have variable defined " + shapeName);
                    }
                    if (memberModel.isSimple() && memberModel.getEnumType() != null) {
                        hasEnumMember = true;
                    }
                    String name = memberModel.getVariable().getVariableName();
                    String type = memberModel.getVariable().getVariableType();
                    ArgumentModel arg = new ArgumentModel().withName(name).withType(type);
                    arg.setDocumentation(memberModel.getDocumentation());
                    consModel.addArgument(arg);
                }
                shapeModel.addConstructor(consModel);
                if (!hasEnumMember) continue;
                ConstructorModel enumCons = new ConstructorModel(shapeName);
                for (String argument : form) {
                    MemberModel memberModel = members.get(argument);
                    VariableModel variable = memberModel.getVariable();
                    String enumType = memberModel.getEnumType();
                    String type = enumType != null ? enumType : variable.getVariableType();
                    ArgumentModel arg = new ArgumentModel().withName(variable.getVariableName()).withType(type).withIsEnumArg(enumType != null);
                    arg.setDocumentation(memberModel.getDocumentation());
                    enumCons.addArgument(arg);
                }
                shapeModel.addConstructor(enumCons);
            }
        }
    }
}

