/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.lite.regions.model.Endpoint;
import software.amazon.awssdk.codegen.lite.regions.model.PartitionRegion;
import software.amazon.awssdk.codegen.lite.regions.model.Service;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class Partition {
    private String partition;
    private Map<String, PartitionRegion> regions;
    private Map<String, Service> services;
    private String partitionName;
    private String dnsSuffix;
    private String regionRegex;
    private Endpoint defaults;

    public Partition() {
    }

    public Partition(@JsonProperty(value="partition") String partition, @JsonProperty(value="regions") Map<String, PartitionRegion> regions, @JsonProperty(value="services") Map<String, Service> services) {
        this.partition = (String)Validate.paramNotNull((Object)partition, (String)"Partition");
        this.regions = regions;
        this.services = services;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public String getDnsSuffix() {
        return this.dnsSuffix;
    }

    public void setDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
    }

    public String getRegionRegex() {
        return this.regionRegex;
    }

    public void setRegionRegex(String regionRegex) {
        this.regionRegex = regionRegex;
    }

    public Endpoint getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Endpoint defaults) {
        this.defaults = defaults;
    }

    public Map<String, PartitionRegion> getRegions() {
        return this.regions;
    }

    public void setRegions(Map<String, PartitionRegion> regions) {
        this.regions = regions;
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public void setServices(Map<String, Service> services) {
        this.services = services;
    }

    public boolean hasRegion(String region) {
        return this.regions.containsKey(region) || this.matchesRegionRegex(region) || this.hasServiceEndpoint(region);
    }

    private boolean matchesRegionRegex(String region) {
        Pattern p = Pattern.compile(this.regionRegex);
        return p.matcher(region).matches();
    }

    @Deprecated
    private boolean hasServiceEndpoint(String endpoint) {
        for (Service s : this.services.values()) {
            if (!s.getEndpoints().containsKey(endpoint)) continue;
            return true;
        }
        return false;
    }
}

