/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegenerationjsonrpccustomized;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.AllTypesRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.AllTypesResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.CodeGenerationJsonRpcCustomizedException;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.EmptyModeledException;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.NestedContainersRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.NestedContainersResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingInputOperationRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingInputOperationResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingOutputOperationRequest;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.StreamingOutputOperationResponse;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.AllTypesRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.AllTypesResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.NestedContainersRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.NestedContainersResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.OperationWithNoInputOrOutputRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.OperationWithNoInputOrOutputResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingInputOperationRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingInputOperationResponseUnmarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingOutputOperationRequestMarshaller;
import software.amazon.awssdk.services.codegenerationjsonrpccustomized.transform.StreamingOutputOperationResponseUnmarshaller;

/**
 * Internal implementation of {@link CodeGenerationJsonRpcCustomizedClient}.
 *
 * @see CodeGenerationJsonRpcCustomizedClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeGenerationJsonRpcCustomizedClient implements CodeGenerationJsonRpcCustomizedClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeGenerationJsonRpcCustomizedClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.protocolFactory = init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGenerationJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGenerationJsonRpcCustomizedClient.AllTypes
     */
    @Override
    public AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, AwsServiceException,
            SdkClientException, CodeGenerationJsonRpcCustomizedException {

        HttpResponseHandler<AllTypesResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new AllTypesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AllTypesRequest, AllTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(allTypesRequest)
                .withMarshaller(new AllTypesRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the NestedContainers operation.
     *
     * @param nestedContainersRequest
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGenerationJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGenerationJsonRpcCustomizedClient.NestedContainers
     */
    @Override
    public NestedContainersResponse nestedContainers(NestedContainersRequest nestedContainersRequest) throws AwsServiceException,
            SdkClientException, CodeGenerationJsonRpcCustomizedException {

        HttpResponseHandler<NestedContainersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new NestedContainersResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<NestedContainersRequest, NestedContainersResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(nestedContainersRequest).withMarshaller(new NestedContainersRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGenerationJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGenerationJsonRpcCustomizedClient.OperationWithNoInputOrOutput
     */
    @Override
    public OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) throws AwsServiceException,
            SdkClientException, CodeGenerationJsonRpcCustomizedException {

        HttpResponseHandler<OperationWithNoInputOrOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new OperationWithNoInputOrOutputResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithNoInputOrOutputRequest, OperationWithNoInputOrOutputResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(operationWithNoInputOrOutputRequest)
                        .withMarshaller(new OperationWithNoInputOrOutputRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the StreamingInputOperation operation.
     *
     * @param streamingInputOperationRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows ''
     * @return Result of the StreamingInputOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGenerationJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGenerationJsonRpcCustomizedClient.StreamingInputOperation
     */
    @Override
    public StreamingInputOperationResponse streamingInputOperation(StreamingInputOperationRequest streamingInputOperationRequest,
            RequestBody requestBody) throws AwsServiceException, SdkClientException, CodeGenerationJsonRpcCustomizedException {

        HttpResponseHandler<StreamingInputOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StreamingInputOperationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StreamingInputOperationRequest, StreamingInputOperationResponse>()
                .withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler)
                .withInput(streamingInputOperationRequest)
                .withMarshaller(
                        new StreamingRequestMarshaller<StreamingInputOperationRequest>(
                                new StreamingInputOperationRequestMarshaller(protocolFactory), requestBody)));
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @param streamingHandler
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        StreamingInputOperationRequest and an InputStream to the response content are provided as parameters to
     *        the callback. The callback may return a transformed type which will be the return value of this method.
     *        See {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows ''.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGenerationJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGenerationJsonRpcCustomizedClient.StreamingOutputOperation
     */
    @Override
    public <ReturnT> ReturnT streamingOutputOperation(StreamingOutputOperationRequest streamingOutputOperationRequest,
            ResponseTransformer<StreamingOutputOperationResponse, ReturnT> responseTransformer) throws AwsServiceException,
            SdkClientException, CodeGenerationJsonRpcCustomizedException {

        HttpResponseHandler<StreamingOutputOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true),
                new StreamingOutputOperationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(
                new ClientExecutionParams<StreamingOutputOperationRequest, StreamingOutputOperationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(streamingOutputOperationRequest)
                        .withMarshaller(new StreamingOutputOperationRequestMarshaller(protocolFactory)), responseTransformer);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(
                new JsonClientMetadata()
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(
                                software.amazon.awssdk.services.codegenerationjsonrpccustomized.model.CodeGenerationJsonRpcCustomizedException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("EmptyModeledException").withModeledClass(
                                        EmptyModeledException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                        .protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
