/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.ComputePlatform;
import software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts;
import software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig;
import software.amazon.awssdk.services.codedeploy.model.ZonalConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentConfigRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, CreateDeploymentConfigRequest> {
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentConfigName").getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::deploymentConfigName)).setter(CreateDeploymentConfigRequest.setter(Builder::deploymentConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build()}).build();
    private static final SdkField<MinimumHealthyHosts> MINIMUM_HEALTHY_HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("minimumHealthyHosts").getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::minimumHealthyHosts)).setter(CreateDeploymentConfigRequest.setter(Builder::minimumHealthyHosts)).constructor(MinimumHealthyHosts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyHosts").build()}).build();
    private static final SdkField<TrafficRoutingConfig> TRAFFIC_ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trafficRoutingConfig").getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::trafficRoutingConfig)).setter(CreateDeploymentConfigRequest.setter(Builder::trafficRoutingConfig)).constructor(TrafficRoutingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficRoutingConfig").build()}).build();
    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computePlatform").getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::computePlatformAsString)).setter(CreateDeploymentConfigRequest.setter(Builder::computePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()}).build();
    private static final SdkField<ZonalConfig> ZONAL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("zonalConfig").getter(CreateDeploymentConfigRequest.getter(CreateDeploymentConfigRequest::zonalConfig)).setter(CreateDeploymentConfigRequest.setter(Builder::zonalConfig)).constructor(ZonalConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_NAME_FIELD, MINIMUM_HEALTHY_HOSTS_FIELD, TRAFFIC_ROUTING_CONFIG_FIELD, COMPUTE_PLATFORM_FIELD, ZONAL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeploymentConfigRequest.memberNameToFieldInitializer();
    private final String deploymentConfigName;
    private final MinimumHealthyHosts minimumHealthyHosts;
    private final TrafficRoutingConfig trafficRoutingConfig;
    private final String computePlatform;
    private final ZonalConfig zonalConfig;

    private CreateDeploymentConfigRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.trafficRoutingConfig = builder.trafficRoutingConfig;
        this.computePlatform = builder.computePlatform;
        this.zonalConfig = builder.zonalConfig;
    }

    public final String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public final MinimumHealthyHosts minimumHealthyHosts() {
        return this.minimumHealthyHosts;
    }

    public final TrafficRoutingConfig trafficRoutingConfig() {
        return this.trafficRoutingConfig;
    }

    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public final String computePlatformAsString() {
        return this.computePlatform;
    }

    public final ZonalConfig zonalConfig() {
        return this.zonalConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficRoutingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentConfigRequest)) {
            return false;
        }
        CreateDeploymentConfigRequest other = (CreateDeploymentConfigRequest)((Object)obj);
        return Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.minimumHealthyHosts(), other.minimumHealthyHosts()) && Objects.equals(this.trafficRoutingConfig(), other.trafficRoutingConfig()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString()) && Objects.equals(this.zonalConfig(), other.zonalConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentConfigRequest").add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("MinimumHealthyHosts", (Object)this.minimumHealthyHosts()).add("TrafficRoutingConfig", (Object)this.trafficRoutingConfig()).add("ComputePlatform", (Object)this.computePlatformAsString()).add("ZonalConfig", (Object)this.zonalConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "minimumHealthyHosts": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyHosts()));
            }
            case "trafficRoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.trafficRoutingConfig()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
            case "zonalConfig": {
                return Optional.ofNullable(clazz.cast(this.zonalConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deploymentConfigName", DEPLOYMENT_CONFIG_NAME_FIELD);
        map.put("minimumHealthyHosts", MINIMUM_HEALTHY_HOSTS_FIELD);
        map.put("trafficRoutingConfig", TRAFFIC_ROUTING_CONFIG_FIELD);
        map.put("computePlatform", COMPUTE_PLATFORM_FIELD);
        map.put("zonalConfig", ZONAL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentConfigRequest, T> g) {
        return obj -> g.apply((CreateDeploymentConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String deploymentConfigName;
        private MinimumHealthyHosts minimumHealthyHosts;
        private TrafficRoutingConfig trafficRoutingConfig;
        private String computePlatform;
        private ZonalConfig zonalConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentConfigRequest model) {
            super(model);
            this.deploymentConfigName(model.deploymentConfigName);
            this.minimumHealthyHosts(model.minimumHealthyHosts);
            this.trafficRoutingConfig(model.trafficRoutingConfig);
            this.computePlatform(model.computePlatform);
            this.zonalConfig(model.zonalConfig);
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return this.minimumHealthyHosts != null ? this.minimumHealthyHosts.toBuilder() : null;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfig() {
            return this.trafficRoutingConfig != null ? this.trafficRoutingConfig.toBuilder() : null;
        }

        public final void setTrafficRoutingConfig(TrafficRoutingConfig.BuilderImpl trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig != null ? trafficRoutingConfig.build() : null;
        }

        @Override
        public final Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final ZonalConfig.Builder getZonalConfig() {
            return this.zonalConfig != null ? this.zonalConfig.toBuilder() : null;
        }

        public final void setZonalConfig(ZonalConfig.BuilderImpl zonalConfig) {
            this.zonalConfig = zonalConfig != null ? zonalConfig.build() : null;
        }

        @Override
        public final Builder zonalConfig(ZonalConfig zonalConfig) {
            this.zonalConfig = zonalConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentConfigRequest build() {
            return new CreateDeploymentConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentConfigRequest> {
        public Builder deploymentConfigName(String var1);

        public Builder minimumHealthyHosts(MinimumHealthyHosts var1);

        default public Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return this.minimumHealthyHosts((MinimumHealthyHosts)((MinimumHealthyHosts.Builder)MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts)).build());
        }

        public Builder trafficRoutingConfig(TrafficRoutingConfig var1);

        default public Builder trafficRoutingConfig(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfig) {
            return this.trafficRoutingConfig((TrafficRoutingConfig)((TrafficRoutingConfig.Builder)TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfig)).build());
        }

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);

        public Builder zonalConfig(ZonalConfig var1);

        default public Builder zonalConfig(Consumer<ZonalConfig.Builder> zonalConfig) {
            return this.zonalConfig((ZonalConfig)((ZonalConfig.Builder)ZonalConfig.builder().applyMutation(zonalConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

