/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;

public class ListDeploymentGroupsIterable
implements SdkIterable<ListDeploymentGroupsResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentGroupsIterable(CodeDeployClient client, ListDeploymentGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentGroupsResponseFetcher();
    }

    public Iterator<ListDeploymentGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> deploymentGroups() {
        Function<ListDeploymentGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentGroups() != null) {
                return response.deploymentGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListDeploymentGroupsIterable resume(ListDeploymentGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDeploymentGroupsIterable(this.client, (ListDeploymentGroupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDeploymentGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListDeploymentGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListDeploymentGroupsResponseFetcher
    implements SyncPageFetcher<ListDeploymentGroupsResponse> {
        private ListDeploymentGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentGroupsResponse nextPage(ListDeploymentGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentGroupsIterable.this.client.listDeploymentGroups(ListDeploymentGroupsIterable.this.firstRequest);
            }
            return ListDeploymentGroupsIterable.this.client.listDeploymentGroups((ListDeploymentGroupsRequest)((Object)ListDeploymentGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

