/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileExistsBehavior {
    DISALLOW("DISALLOW"),
    OVERWRITE("OVERWRITE"),
    RETAIN("RETAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileExistsBehavior> VALUE_MAP;
    private final String value;

    private FileExistsBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileExistsBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileExistsBehavior> knownValues() {
        EnumSet<FileExistsBehavior> knownValues = EnumSet.allOf(FileExistsBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileExistsBehavior.class, FileExistsBehavior::toString);
    }
}

