/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployAsyncWaiter;
import software.amazon.awssdk.services.codedeploy.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultCodeDeployAsyncWaiter
implements CodeDeployAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final CodeDeployAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetDeploymentResponse> deploymentSuccessfulWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultCodeDeployAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CodeDeployAsyncClient)CodeDeployAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.deploymentSuccessfulWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetDeploymentResponse.class).acceptors(DefaultCodeDeployAsyncWaiter.deploymentSuccessfulWaiterAcceptors())).overrideConfiguration(DefaultCodeDeployAsyncWaiter.deploymentSuccessfulWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentSuccessful(GetDeploymentRequest getDeploymentRequest) {
        return this.deploymentSuccessfulWaiter.runAsync(() -> this.client.getDeployment(this.applyWaitersUserAgent(getDeploymentRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentSuccessful(GetDeploymentRequest getDeploymentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.deploymentSuccessfulWaiter.runAsync(() -> this.client.getDeployment(this.applyWaitersUserAgent(getDeploymentRequest)), DefaultCodeDeployAsyncWaiter.deploymentSuccessfulWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetDeploymentResponse>> deploymentSuccessfulWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetDeploymentResponse>> result = new ArrayList<WaiterAcceptor<? super GetDeploymentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("deploymentInfo").field("status").value(), "Succeeded");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("deploymentInfo").field("status").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (deploymentInfo.status=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("deploymentInfo").field("status").value(), "Stopped");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (deploymentInfo.status=Stopped) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration deploymentSuccessfulWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CodeDeployAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CodeDeployRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeDeployRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CodeDeployAsyncWaiter.Builder {
        private CodeDeployAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public CodeDeployAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public CodeDeployAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CodeDeployAsyncWaiter.Builder client(CodeDeployAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CodeDeployAsyncWaiter build() {
            return new DefaultCodeDeployAsyncWaiter(this);
        }
    }
}

