/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AutoScalingGroup.getter(AutoScalingGroup::name)).setter(AutoScalingGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hook").getter(AutoScalingGroup.getter(AutoScalingGroup::hook)).setter(AutoScalingGroup.setter(Builder::hook)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hook").build()}).build();
    private static final SdkField<String> TERMINATION_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("terminationHook").getter(AutoScalingGroup.getter(AutoScalingGroup::terminationHook)).setter(AutoScalingGroup.setter(Builder::terminationHook)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminationHook").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOOK_FIELD, TERMINATION_HOOK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String hook;
    private final String terminationHook;

    private AutoScalingGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.hook = builder.hook;
        this.terminationHook = builder.terminationHook;
    }

    public final String name() {
        return this.name;
    }

    public final String hook() {
        return this.hook;
    }

    public final String terminationHook() {
        return this.terminationHook;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hook());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationHook());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.hook(), other.hook()) && Objects.equals(this.terminationHook(), other.terminationHook());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroup").add("Name", (Object)this.name()).add("Hook", (Object)this.hook()).add("TerminationHook", (Object)this.terminationHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "hook": {
                return Optional.ofNullable(clazz.cast(this.hook()));
            }
            case "terminationHook": {
                return Optional.ofNullable(clazz.cast(this.terminationHook()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroup, T> g) {
        return obj -> g.apply((AutoScalingGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String hook;
        private String terminationHook;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            this.name(model.name);
            this.hook(model.hook);
            this.terminationHook(model.terminationHook);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getHook() {
            return this.hook;
        }

        public final void setHook(String hook) {
            this.hook = hook;
        }

        @Override
        public final Builder hook(String hook) {
            this.hook = hook;
            return this;
        }

        public final String getTerminationHook() {
            return this.terminationHook;
        }

        public final void setTerminationHook(String terminationHook) {
            this.terminationHook = terminationHook;
        }

        @Override
        public final Builder terminationHook(String terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroup> {
        public Builder name(String var1);

        public Builder hook(String var1);

        public Builder terminationHook(String var1);
    }
}

