/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventListCopier;
import software.amazon.awssdk.services.codedeploy.model.TargetLabel;
import software.amazon.awssdk.services.codedeploy.model.TargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTarget> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(InstanceTarget.getter(InstanceTarget::deploymentId)).setter(InstanceTarget.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(InstanceTarget.getter(InstanceTarget::targetId)).setter(InstanceTarget.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(InstanceTarget.getter(InstanceTarget::targetArn)).setter(InstanceTarget.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(InstanceTarget.getter(InstanceTarget::statusAsString)).setter(InstanceTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(InstanceTarget.getter(InstanceTarget::lastUpdatedAt)).setter(InstanceTarget.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<List<LifecycleEvent>> LIFECYCLE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecycleEvents").getter(InstanceTarget.getter(InstanceTarget::lifecycleEvents)).setter(InstanceTarget.setter(Builder::lifecycleEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceLabel").getter(InstanceTarget.getter(InstanceTarget::instanceLabelAsString)).setter(InstanceTarget.setter(Builder::instanceLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, TARGET_ID_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_EVENTS_FIELD, INSTANCE_LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String targetId;
    private final String targetArn;
    private final String status;
    private final Instant lastUpdatedAt;
    private final List<LifecycleEvent> lifecycleEvents;
    private final String instanceLabel;

    private InstanceTarget(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.targetId = builder.targetId;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.instanceLabel = builder.instanceLabel;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String targetId() {
        return this.targetId;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public TargetStatus status() {
        return TargetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public boolean hasLifecycleEvents() {
        return this.lifecycleEvents != null && !(this.lifecycleEvents instanceof SdkAutoConstructList);
    }

    public List<LifecycleEvent> lifecycleEvents() {
        return this.lifecycleEvents;
    }

    public TargetLabel instanceLabel() {
        return TargetLabel.fromValue(this.instanceLabel);
    }

    public String instanceLabelAsString() {
        return this.instanceLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceLabelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTarget)) {
            return false;
        }
        InstanceTarget other = (InstanceTarget)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.lifecycleEvents(), other.lifecycleEvents()) && Objects.equals(this.instanceLabelAsString(), other.instanceLabelAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceTarget").add("DeploymentId", (Object)this.deploymentId()).add("TargetId", (Object)this.targetId()).add("TargetArn", (Object)this.targetArn()).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleEvents", this.lifecycleEvents()).add("InstanceLabel", (Object)this.instanceLabelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleEvents": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEvents()));
            }
            case "instanceLabel": {
                return Optional.ofNullable(clazz.cast(this.instanceLabelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTarget, T> g) {
        return obj -> g.apply((InstanceTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String targetId;
        private String targetArn;
        private String status;
        private Instant lastUpdatedAt;
        private List<LifecycleEvent> lifecycleEvents = DefaultSdkAutoConstructList.getInstance();
        private String instanceLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTarget model) {
            this.deploymentId(model.deploymentId);
            this.targetId(model.targetId);
            this.targetArn(model.targetArn);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleEvents(model.lifecycleEvents);
            this.instanceLabel(model.instanceLabel);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Collection<LifecycleEvent.Builder> getLifecycleEvents() {
            return this.lifecycleEvents != null ? (Collection)this.lifecycleEvents.stream().map(LifecycleEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(LifecycleEvent ... lifecycleEvents) {
            this.lifecycleEvents(Arrays.asList(lifecycleEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... lifecycleEvents) {
            this.lifecycleEvents(Stream.of(lifecycleEvents).map(c -> (LifecycleEvent)((LifecycleEvent.Builder)LifecycleEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleEvents(Collection<LifecycleEvent.BuilderImpl> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copyFromBuilder(lifecycleEvents);
        }

        public final String getInstanceLabel() {
            return this.instanceLabel;
        }

        @Override
        public final Builder instanceLabel(String instanceLabel) {
            this.instanceLabel = instanceLabel;
            return this;
        }

        @Override
        public final Builder instanceLabel(TargetLabel instanceLabel) {
            this.instanceLabel(instanceLabel == null ? null : instanceLabel.toString());
            return this;
        }

        public final void setInstanceLabel(String instanceLabel) {
            this.instanceLabel = instanceLabel;
        }

        public InstanceTarget build() {
            return new InstanceTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTarget> {
        public Builder deploymentId(String var1);

        public Builder targetId(String var1);

        public Builder targetArn(String var1);

        public Builder status(String var1);

        public Builder status(TargetStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleEvents(Collection<LifecycleEvent> var1);

        public Builder lifecycleEvents(LifecycleEvent ... var1);

        public Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... var1);

        public Builder instanceLabel(String var1);

        public Builder instanceLabel(TargetLabel var1);
    }
}

