/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TrafficRoutingType {
    TIME_BASED_CANARY("TimeBasedCanary"),
    TIME_BASED_LINEAR("TimeBasedLinear"),
    ALL_AT_ONCE("AllAtOnce"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TrafficRoutingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrafficRoutingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TrafficRoutingType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrafficRoutingType> knownValues() {
        return Stream.of(TrafficRoutingType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

