/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListDeploymentConfigs operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeploymentConfigsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<ListDeploymentConfigsResponse.Builder, ListDeploymentConfigsResponse> {
    private static final SdkField<List<String>> DEPLOYMENT_CONFIGS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListDeploymentConfigsResponse::deploymentConfigsList))
            .setter(setter(Builder::deploymentConfigsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeploymentConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIGS_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> deploymentConfigsList;

    private final String nextToken;

    private ListDeploymentConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigsList = builder.deploymentConfigsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DeploymentConfigsList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDeploymentConfigsList() {
        return deploymentConfigsList != null && !(deploymentConfigsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of deployment configurations, including built-in configurations such as CodeDeployDefault.OneAtATime.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeploymentConfigsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of deployment configurations, including built-in configurations such as
     *         CodeDeployDefault.OneAtATime.
     */
    public List<String> deploymentConfigsList() {
        return deploymentConfigsList;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * deployment configurations call to return the next set of deployment configurations in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list deployment configurations call to return the next set of deployment configurations in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigsList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentConfigsResponse)) {
            return false;
        }
        ListDeploymentConfigsResponse other = (ListDeploymentConfigsResponse) obj;
        return Objects.equals(deploymentConfigsList(), other.deploymentConfigsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeploymentConfigsResponse").add("DeploymentConfigsList", deploymentConfigsList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentConfigsList":
            return Optional.ofNullable(clazz.cast(deploymentConfigsList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentConfigsResponse, T> g) {
        return obj -> g.apply((ListDeploymentConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDeploymentConfigsResponse> {
        /**
         * <p>
         * A list of deployment configurations, including built-in configurations such as CodeDeployDefault.OneAtATime.
         * </p>
         * 
         * @param deploymentConfigsList
         *        A list of deployment configurations, including built-in configurations such as
         *        CodeDeployDefault.OneAtATime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigsList(Collection<String> deploymentConfigsList);

        /**
         * <p>
         * A list of deployment configurations, including built-in configurations such as CodeDeployDefault.OneAtATime.
         * </p>
         * 
         * @param deploymentConfigsList
         *        A list of deployment configurations, including built-in configurations such as
         *        CodeDeployDefault.OneAtATime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigsList(String... deploymentConfigsList);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list deployment configurations call to return the next set of deployment configurations in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list deployment configurations call to return the next set of deployment configurations in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<String> deploymentConfigsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentConfigsResponse model) {
            super(model);
            deploymentConfigsList(model.deploymentConfigsList);
            nextToken(model.nextToken);
        }

        public final Collection<String> getDeploymentConfigsList() {
            return deploymentConfigsList;
        }

        @Override
        public final Builder deploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentConfigsList(String... deploymentConfigsList) {
            deploymentConfigsList(Arrays.asList(deploymentConfigsList));
            return this;
        }

        public final void setDeploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentConfigsResponse build() {
            return new ListDeploymentConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
