/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how traffic is rerouted to instances in a replacement environment in a blue/green deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentReadyOption implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentReadyOption.Builder, DeploymentReadyOption> {
    private static final SdkField<String> ACTION_ON_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentReadyOption::actionOnTimeoutAsString)).setter(setter(Builder::actionOnTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionOnTimeout").build()).build();

    private static final SdkField<Integer> WAIT_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DeploymentReadyOption::waitTimeInMinutes)).setter(setter(Builder::waitTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitTimeInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ON_TIMEOUT_FIELD,
            WAIT_TIME_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionOnTimeout;

    private final Integer waitTimeInMinutes;

    private DeploymentReadyOption(BuilderImpl builder) {
        this.actionOnTimeout = builder.actionOnTimeout;
        this.waitTimeInMinutes = builder.waitTimeInMinutes;
    }

    /**
     * <p>
     * Information about when to reroute traffic from an original environment to a replacement environment in a
     * blue/green deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision
     * is installed on the instances in the replacement environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using
     * <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the specified wait period, the
     * deployment status is changed to Stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOnTimeout}
     * will return {@link DeploymentReadyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionOnTimeoutAsString}.
     * </p>
     * 
     * @return Information about when to reroute traffic from an original environment to a replacement environment in a
     *         blue/green deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application
     *         revision is installed on the instances in the replacement environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started
     *         using <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the specified wait
     *         period, the deployment status is changed to Stopped.
     *         </p>
     *         </li>
     * @see DeploymentReadyAction
     */
    public DeploymentReadyAction actionOnTimeout() {
        return DeploymentReadyAction.fromValue(actionOnTimeout);
    }

    /**
     * <p>
     * Information about when to reroute traffic from an original environment to a replacement environment in a
     * blue/green deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision
     * is installed on the instances in the replacement environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using
     * <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the specified wait period, the
     * deployment status is changed to Stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOnTimeout}
     * will return {@link DeploymentReadyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionOnTimeoutAsString}.
     * </p>
     * 
     * @return Information about when to reroute traffic from an original environment to a replacement environment in a
     *         blue/green deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application
     *         revision is installed on the instances in the replacement environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started
     *         using <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the specified wait
     *         period, the deployment status is changed to Stopped.
     *         </p>
     *         </li>
     * @see DeploymentReadyAction
     */
    public String actionOnTimeoutAsString() {
        return actionOnTimeout;
    }

    /**
     * <p>
     * The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is
     * not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
     * </p>
     * 
     * @return The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if
     *         rerouting is not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
     */
    public Integer waitTimeInMinutes() {
        return waitTimeInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionOnTimeoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(waitTimeInMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentReadyOption)) {
            return false;
        }
        DeploymentReadyOption other = (DeploymentReadyOption) obj;
        return Objects.equals(actionOnTimeoutAsString(), other.actionOnTimeoutAsString())
                && Objects.equals(waitTimeInMinutes(), other.waitTimeInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentReadyOption").add("ActionOnTimeout", actionOnTimeoutAsString())
                .add("WaitTimeInMinutes", waitTimeInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionOnTimeout":
            return Optional.ofNullable(clazz.cast(actionOnTimeoutAsString()));
        case "waitTimeInMinutes":
            return Optional.ofNullable(clazz.cast(waitTimeInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentReadyOption, T> g) {
        return obj -> g.apply((DeploymentReadyOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentReadyOption> {
        /**
         * <p>
         * Information about when to reroute traffic from an original environment to a replacement environment in a
         * blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application
         * revision is installed on the instances in the replacement environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using
         * <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the specified wait period,
         * the deployment status is changed to Stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param actionOnTimeout
         *        Information about when to reroute traffic from an original environment to a replacement environment in
         *        a blue/green deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new
         *        application revision is installed on the instances in the replacement environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is
         *        started using <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the
         *        specified wait period, the deployment status is changed to Stopped.
         *        </p>
         *        </li>
         * @see DeploymentReadyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentReadyAction
         */
        Builder actionOnTimeout(String actionOnTimeout);

        /**
         * <p>
         * Information about when to reroute traffic from an original environment to a replacement environment in a
         * blue/green deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application
         * revision is installed on the instances in the replacement environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using
         * <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the specified wait period,
         * the deployment status is changed to Stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param actionOnTimeout
         *        Information about when to reroute traffic from an original environment to a replacement environment in
         *        a blue/green deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new
         *        application revision is installed on the instances in the replacement environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is
         *        started using <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the
         *        specified wait period, the deployment status is changed to Stopped.
         *        </p>
         *        </li>
         * @see DeploymentReadyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentReadyAction
         */
        Builder actionOnTimeout(DeploymentReadyAction actionOnTimeout);

        /**
         * <p>
         * The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting
         * is not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
         * </p>
         * 
         * @param waitTimeInMinutes
         *        The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if
         *        rerouting is not started manually. Applies only to the STOP_DEPLOYMENT option for actionOnTimeout
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitTimeInMinutes(Integer waitTimeInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String actionOnTimeout;

        private Integer waitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentReadyOption model) {
            actionOnTimeout(model.actionOnTimeout);
            waitTimeInMinutes(model.waitTimeInMinutes);
        }

        public final String getActionOnTimeoutAsString() {
            return actionOnTimeout;
        }

        @Override
        public final Builder actionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
            return this;
        }

        @Override
        public final Builder actionOnTimeout(DeploymentReadyAction actionOnTimeout) {
            this.actionOnTimeout(actionOnTimeout == null ? null : actionOnTimeout.toString());
            return this;
        }

        public final void setActionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
        }

        public final Integer getWaitTimeInMinutes() {
            return waitTimeInMinutes;
        }

        @Override
        public final Builder waitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
            return this;
        }

        public final void setWaitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
        }

        @Override
        public DeploymentReadyOption build() {
            return new DeploymentReadyOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
