/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDeploymentGroupsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, BatchGetDeploymentGroupsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchGetDeploymentGroupsRequest.getter(BatchGetDeploymentGroupsRequest::applicationName)).setter(BatchGetDeploymentGroupsRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<List<String>> DEPLOYMENT_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetDeploymentGroupsRequest.getter(BatchGetDeploymentGroupsRequest::deploymentGroupNames)).setter(BatchGetDeploymentGroupsRequest.setter(Builder::deploymentGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, DEPLOYMENT_GROUP_NAMES_FIELD));
    private final String applicationName;
    private final List<String> deploymentGroupNames;

    private BatchGetDeploymentGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupNames = builder.deploymentGroupNames;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<String> deploymentGroupNames() {
        return this.deploymentGroupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsRequest)) {
            return false;
        }
        BatchGetDeploymentGroupsRequest other = (BatchGetDeploymentGroupsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupNames(), other.deploymentGroupNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetDeploymentGroupsRequest").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupNames", this.deploymentGroupNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupNames": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentGroupsRequest, T> g) {
        return obj -> g.apply((BatchGetDeploymentGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private List<String> deploymentGroupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.deploymentGroupNames(model.deploymentGroupNames);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<String> getDeploymentGroupNames() {
            return this.deploymentGroupNames;
        }

        @Override
        public final Builder deploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupNames(String ... deploymentGroupNames) {
            this.deploymentGroupNames(Arrays.asList(deploymentGroupNames));
            return this;
        }

        public final void setDeploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDeploymentGroupsRequest build() {
            return new BatchGetDeploymentGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDeploymentGroupsRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupNames(Collection<String> var1);

        public Builder deploymentGroupNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

