/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;

public class ListDeploymentGroupsPublisher
implements SdkPublisher<ListDeploymentGroupsResponse> {
    private final CodeDeployAsyncClient client;
    private final ListDeploymentGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentGroupsPublisher(CodeDeployAsyncClient client, ListDeploymentGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentGroupsPublisher(CodeDeployAsyncClient client, ListDeploymentGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<String> deploymentGroups() {
        Function<ListDeploymentGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentGroups() != null) {
                return response.deploymentGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListDeploymentGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListDeploymentGroupsPublisher resume(ListDeploymentGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDeploymentGroupsPublisher(this.client, (ListDeploymentGroupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDeploymentGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDeploymentGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDeploymentGroupsResponseFetcher
    implements AsyncPageFetcher<ListDeploymentGroupsResponse> {
        private ListDeploymentGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentGroupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListDeploymentGroupsResponse> nextPage(ListDeploymentGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentGroupsPublisher.this.client.listDeploymentGroups(ListDeploymentGroupsPublisher.this.firstRequest);
            }
            return ListDeploymentGroupsPublisher.this.client.listDeploymentGroups((ListDeploymentGroupsRequest)((Object)ListDeploymentGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

