/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;

public final class ListApplicationsPaginator
implements SdkIterable<ListApplicationsResponse> {
    private final CodeDeployClient client;
    private final ListApplicationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListApplicationsPaginator(CodeDeployClient client, ListApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    public Iterator<ListApplicationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> applications() {
        Function<ListApplicationsResponse, Iterator> getIterator = response -> response != null ? response.applications().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListApplicationsResponseFetcher
    implements NextPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListApplicationsResponse nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsPaginator.this.client.listApplications(ListApplicationsPaginator.this.firstRequest);
            }
            return ListApplicationsPaginator.this.client.listApplications((ListApplicationsRequest)((Object)ListApplicationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

