/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesResponse;

public final class ListDeploymentInstancesPaginator
implements SdkIterable<ListDeploymentInstancesResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDeploymentInstancesPaginator(CodeDeployClient client, ListDeploymentInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentInstancesResponseFetcher();
    }

    public Iterator<ListDeploymentInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> instancesList() {
        Function<ListDeploymentInstancesResponse, Iterator> getIterator = response -> response != null ? response.instancesList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDeploymentInstancesResponseFetcher
    implements NextPageFetcher<ListDeploymentInstancesResponse> {
        private ListDeploymentInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDeploymentInstancesResponse nextPage(ListDeploymentInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentInstancesPaginator.this.client.listDeploymentInstances(ListDeploymentInstancesPaginator.this.firstRequest);
            }
            return ListDeploymentInstancesPaginator.this.client.listDeploymentInstances((ListDeploymentInstancesRequest)((Object)ListDeploymentInstancesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

