/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;

public final class ListApplicationRevisionsPaginator
implements SdkIterable<ListApplicationRevisionsResponse> {
    private final CodeDeployClient client;
    private final ListApplicationRevisionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListApplicationRevisionsPaginator(CodeDeployClient client, ListApplicationRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationRevisionsResponseFetcher();
    }

    public Iterator<ListApplicationRevisionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<RevisionLocation> revisions() {
        Function<ListApplicationRevisionsResponse, Iterator> getIterator = response -> response != null ? response.revisions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListApplicationRevisionsResponseFetcher
    implements NextPageFetcher<ListApplicationRevisionsResponse> {
        private ListApplicationRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationRevisionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListApplicationRevisionsResponse nextPage(ListApplicationRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationRevisionsPaginator.this.client.listApplicationRevisions(ListApplicationRevisionsPaginator.this.firstRequest);
            }
            return ListApplicationRevisionsPaginator.this.client.listApplicationRevisions((ListApplicationRevisionsRequest)((Object)ListApplicationRevisionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

