/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.GitHubLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GitHubLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, GitHubLocation> {
    private final String repository;
    private final String commitId;

    private GitHubLocation(BuilderImpl builder) {
        this.repository = builder.repository;
        this.commitId = builder.commitId;
    }

    public String repository() {
        return this.repository;
    }

    public String commitId() {
        return this.commitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubLocation)) {
            return false;
        }
        GitHubLocation other = (GitHubLocation)obj;
        return Objects.equals(this.repository(), other.repository()) && Objects.equals(this.commitId(), other.commitId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.repository() != null) {
            sb.append("Repository: ").append(this.repository()).append(",");
        }
        if (this.commitId() != null) {
            sb.append("CommitId: ").append(this.commitId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repository": {
                return Optional.of(clazz.cast(this.repository()));
            }
            case "commitId": {
                return Optional.of(clazz.cast(this.commitId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GitHubLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String repository;
        private String commitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubLocation model) {
            this.repository(model.repository);
            this.commitId(model.commitId);
        }

        public final String getRepository() {
            return this.repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getCommitId() {
            return this.commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public GitHubLocation build() {
            return new GitHubLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GitHubLocation> {
        public Builder repository(String var1);

        public Builder commitId(String var1);
    }
}

