/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup;

@SdkInternalApi
public class AutoScalingGroupMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> HOOK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hook").build();
    private static final AutoScalingGroupMarshaller INSTANCE = new AutoScalingGroupMarshaller();

    public static AutoScalingGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingGroup autoScalingGroup, ProtocolMarshaller protocolMarshaller) {
        if (autoScalingGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)autoScalingGroup.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)autoScalingGroup.hook(), HOOK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

