/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.ApplicationInfo;

@SdkInternalApi
public class ApplicationInfoMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationId").build();
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationName").build();
    private static final MarshallingInfo<Instant> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").build();
    private static final MarshallingInfo<Boolean> LINKEDTOGITHUB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("linkedToGitHub").build();
    private static final MarshallingInfo<String> GITHUBACCOUNTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gitHubAccountName").build();
    private static final ApplicationInfoMarshaller INSTANCE = new ApplicationInfoMarshaller();

    public static ApplicationInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationInfo applicationInfo, ProtocolMarshaller protocolMarshaller) {
        if (applicationInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)applicationInfo.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)applicationInfo.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)applicationInfo.createTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall((Object)applicationInfo.linkedToGitHub(), LINKEDTOGITHUB_BINDING);
            protocolMarshaller.marshall((Object)applicationInfo.gitHubAccountName(), GITHUBACCOUNTNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

