/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterOnPremisesInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
    private final String instanceName;
    private final String iamSessionArn;
    private final String iamUserArn;

    private RegisterOnPremisesInstanceRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String iamSessionArn() {
        return this.iamSessionArn;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterOnPremisesInstanceRequest)) {
            return false;
        }
        RegisterOnPremisesInstanceRequest other = (RegisterOnPremisesInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.iamSessionArn(), other.iamSessionArn()) && Objects.equals(this.iamUserArn(), other.iamUserArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.iamSessionArn() != null) {
            sb.append("IamSessionArn: ").append(this.iamSessionArn()).append(",");
        }
        if (this.iamUserArn() != null) {
            sb.append("IamUserArn: ").append(this.iamUserArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "iamSessionArn": {
                return Optional.of(clazz.cast(this.iamSessionArn()));
            }
            case "iamUserArn": {
                return Optional.of(clazz.cast(this.iamUserArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String iamSessionArn;
        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterOnPremisesInstanceRequest model) {
            this.instanceName(model.instanceName);
            this.iamSessionArn(model.iamSessionArn);
            this.iamUserArn(model.iamUserArn);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return this.iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public RegisterOnPremisesInstanceRequest build() {
            return new RegisterOnPremisesInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
        public Builder instanceName(String var1);

        public Builder iamSessionArn(String var1);

        public Builder iamUserArn(String var1);
    }
}

