/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatus;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatusListCopier;
import software.amazon.awssdk.services.codedeploy.model.InstanceType;
import software.amazon.awssdk.services.codedeploy.model.InstanceTypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListDeploymentInstancesRequest> {
    private final String deploymentId;
    private final String nextToken;
    private final List<String> instanceStatusFilter;
    private final List<String> instanceTypeFilter;

    private ListDeploymentInstancesRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.nextToken = builder.nextToken;
        this.instanceStatusFilter = builder.instanceStatusFilter;
        this.instanceTypeFilter = builder.instanceTypeFilter;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<InstanceStatus> instanceStatusFilter() {
        return TypeConverter.convert(this.instanceStatusFilter, InstanceStatus::fromValue);
    }

    public List<String> instanceStatusFilterStrings() {
        return this.instanceStatusFilter;
    }

    public List<InstanceType> instanceTypeFilter() {
        return TypeConverter.convert(this.instanceTypeFilter, InstanceType::fromValue);
    }

    public List<String> instanceTypeFilterStrings() {
        return this.instanceTypeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatusFilterStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeFilterStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesRequest)) {
            return false;
        }
        ListDeploymentInstancesRequest other = (ListDeploymentInstancesRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.instanceStatusFilterStrings(), other.instanceStatusFilterStrings()) && Objects.equals(this.instanceTypeFilterStrings(), other.instanceTypeFilterStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.instanceStatusFilterStrings() != null) {
            sb.append("InstanceStatusFilter: ").append(this.instanceStatusFilterStrings()).append(",");
        }
        if (this.instanceTypeFilterStrings() != null) {
            sb.append("InstanceTypeFilter: ").append(this.instanceTypeFilterStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "instanceStatusFilter": {
                return Optional.of(clazz.cast(this.instanceStatusFilterStrings()));
            }
            case "instanceTypeFilter": {
                return Optional.of(clazz.cast(this.instanceTypeFilterStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String nextToken;
        private List<String> instanceStatusFilter;
        private List<String> instanceTypeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentInstancesRequest model) {
            this.deploymentId(model.deploymentId);
            this.nextToken(model.nextToken);
            this.instanceStatusFilter(model.instanceStatusFilter);
            this.instanceTypeFilter(model.instanceTypeFilter);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getInstanceStatusFilter() {
            return this.instanceStatusFilter;
        }

        @Override
        public final Builder instanceStatusFilter(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusFilter(String ... instanceStatusFilter) {
            this.instanceStatusFilter(Arrays.asList(instanceStatusFilter));
            return this;
        }

        public final void setInstanceStatusFilter(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
        }

        public final Collection<String> getInstanceTypeFilter() {
            return this.instanceTypeFilter;
        }

        @Override
        public final Builder instanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(String ... instanceTypeFilter) {
            this.instanceTypeFilter(Arrays.asList(instanceTypeFilter));
            return this;
        }

        public final void setInstanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
        }

        public ListDeploymentInstancesRequest build() {
            return new ListDeploymentInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeploymentInstancesRequest> {
        public Builder deploymentId(String var1);

        public Builder nextToken(String var1);

        public Builder instanceStatusFilter(Collection<String> var1);

        public Builder instanceStatusFilter(String ... var1);

        public Builder instanceTypeFilter(Collection<String> var1);

        public Builder instanceTypeFilter(String ... var1);
    }
}

