/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetOnPremisesInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetOnPremisesInstancesRequest> {
    private final List<String> instanceNames;

    private BatchGetOnPremisesInstancesRequest(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesRequest)) {
            return false;
        }
        BatchGetOnPremisesInstancesRequest other = (BatchGetOnPremisesInstancesRequest)((Object)obj);
        return Objects.equals(this.instanceNames(), other.instanceNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceNames() != null) {
            sb.append("InstanceNames: ").append(this.instanceNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceNames": {
                return Optional.of(clazz.cast(this.instanceNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceNames;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesRequest model) {
            this.instanceNames(model.instanceNames);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        public BatchGetOnPremisesInstancesRequest build() {
            return new BatchGetOnPremisesInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetOnPremisesInstancesRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);
    }
}

