/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetDeploymentGroupsRequest> {
    private final String applicationName;
    private final List<String> deploymentGroupNames;

    private BatchGetDeploymentGroupsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupNames = builder.deploymentGroupNames;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<String> deploymentGroupNames() {
        return this.deploymentGroupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsRequest)) {
            return false;
        }
        BatchGetDeploymentGroupsRequest other = (BatchGetDeploymentGroupsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupNames(), other.deploymentGroupNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupNames() != null) {
            sb.append("DeploymentGroupNames: ").append(this.deploymentGroupNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupNames": {
                return Optional.of(clazz.cast(this.deploymentGroupNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private List<String> deploymentGroupNames;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsRequest model) {
            this.applicationName(model.applicationName);
            this.deploymentGroupNames(model.deploymentGroupNames);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<String> getDeploymentGroupNames() {
            return this.deploymentGroupNames;
        }

        @Override
        public final Builder deploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupNames(String ... deploymentGroupNames) {
            this.deploymentGroupNames(Arrays.asList(deploymentGroupNames));
            return this;
        }

        public final void setDeploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
        }

        public BatchGetDeploymentGroupsRequest build() {
            return new BatchGetDeploymentGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetDeploymentGroupsRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupNames(Collection<String> var1);

        public Builder deploymentGroupNames(String ... var1);
    }
}

