/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetApplicationRevisionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
    private final String applicationName;
    private final String errorMessage;
    private final List<RevisionInfo> revisions;

    private BatchGetApplicationRevisionsResponse(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.errorMessage = builder.errorMessage;
        this.revisions = builder.revisions;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<RevisionInfo> revisions() {
        return this.revisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsResponse)) {
            return false;
        }
        BatchGetApplicationRevisionsResponse other = (BatchGetApplicationRevisionsResponse)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.revisions(), other.revisions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (this.revisions() != null) {
            sb.append("Revisions: ").append(this.revisions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "errorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
            case "revisions": {
                return Optional.of(clazz.cast(this.revisions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String errorMessage;
        private List<RevisionInfo> revisions;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsResponse model) {
            this.applicationName(model.applicationName);
            this.errorMessage(model.errorMessage);
            this.revisions(model.revisions);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<RevisionInfo.Builder> getRevisions() {
            return this.revisions != null ? (Collection)this.revisions.stream().map(RevisionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionInfo> revisions) {
            this.revisions = RevisionInfoListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionInfo ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        public final void setRevisions(Collection<RevisionInfo.BuilderImpl> revisions) {
            this.revisions = RevisionInfoListCopier.copyFromBuilder(revisions);
        }

        public BatchGetApplicationRevisionsResponse build() {
            return new BatchGetApplicationRevisionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
        public Builder applicationName(String var1);

        public Builder errorMessage(String var1);

        public Builder revisions(Collection<RevisionInfo> var1);

        public Builder revisions(RevisionInfo ... var1);
    }
}

