/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.GitHubLocation;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocationType;
import software.amazon.awssdk.services.codedeploy.model.S3Location;
import software.amazon.awssdk.services.codedeploy.transform.RevisionLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RevisionLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, RevisionLocation> {
    private final String revisionType;
    private final S3Location s3Location;
    private final GitHubLocation gitHubLocation;

    private RevisionLocation(BuilderImpl builder) {
        this.revisionType = builder.revisionType;
        this.s3Location = builder.s3Location;
        this.gitHubLocation = builder.gitHubLocation;
    }

    public RevisionLocationType revisionType() {
        return RevisionLocationType.fromValue(this.revisionType);
    }

    public String revisionTypeString() {
        return this.revisionType;
    }

    public S3Location s3Location() {
        return this.s3Location;
    }

    public GitHubLocation gitHubLocation() {
        return this.gitHubLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.revisionTypeString() == null ? 0 : this.revisionTypeString().hashCode());
        hashCode = 31 * hashCode + (this.s3Location() == null ? 0 : this.s3Location().hashCode());
        hashCode = 31 * hashCode + (this.gitHubLocation() == null ? 0 : this.gitHubLocation().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionLocation)) {
            return false;
        }
        RevisionLocation other = (RevisionLocation)obj;
        if (other.revisionTypeString() == null ^ this.revisionTypeString() == null) {
            return false;
        }
        if (other.revisionTypeString() != null && !other.revisionTypeString().equals(this.revisionTypeString())) {
            return false;
        }
        if (other.s3Location() == null ^ this.s3Location() == null) {
            return false;
        }
        if (other.s3Location() != null && !other.s3Location().equals(this.s3Location())) {
            return false;
        }
        if (other.gitHubLocation() == null ^ this.gitHubLocation() == null) {
            return false;
        }
        return other.gitHubLocation() == null || other.gitHubLocation().equals(this.gitHubLocation());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.revisionTypeString() != null) {
            sb.append("RevisionType: ").append(this.revisionTypeString()).append(",");
        }
        if (this.s3Location() != null) {
            sb.append("S3Location: ").append(this.s3Location()).append(",");
        }
        if (this.gitHubLocation() != null) {
            sb.append("GitHubLocation: ").append(this.gitHubLocation()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisionType": {
                return Optional.of(clazz.cast(this.revisionTypeString()));
            }
            case "s3Location": {
                return Optional.of(clazz.cast(this.s3Location()));
            }
            case "gitHubLocation": {
                return Optional.of(clazz.cast(this.gitHubLocation()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RevisionLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String revisionType;
        private S3Location s3Location;
        private GitHubLocation gitHubLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionLocation model) {
            this.revisionType(model.revisionType);
            this.s3Location(model.s3Location);
            this.gitHubLocation(model.gitHubLocation);
        }

        public final String getRevisionType() {
            return this.revisionType;
        }

        @Override
        public final Builder revisionType(String revisionType) {
            this.revisionType = revisionType;
            return this;
        }

        @Override
        public final Builder revisionType(RevisionLocationType revisionType) {
            this.revisionType(revisionType.toString());
            return this;
        }

        public final void setRevisionType(String revisionType) {
            this.revisionType = revisionType;
        }

        public final S3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public final GitHubLocation.Builder getGitHubLocation() {
            return this.gitHubLocation != null ? this.gitHubLocation.toBuilder() : null;
        }

        @Override
        public final Builder gitHubLocation(GitHubLocation gitHubLocation) {
            this.gitHubLocation = gitHubLocation;
            return this;
        }

        public final void setGitHubLocation(GitHubLocation.BuilderImpl gitHubLocation) {
            this.gitHubLocation = gitHubLocation != null ? gitHubLocation.build() : null;
        }

        public RevisionLocation build() {
            return new RevisionLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RevisionLocation> {
        public Builder revisionType(String var1);

        public Builder revisionType(RevisionLocationType var1);

        public Builder s3Location(S3Location var1);

        public Builder gitHubLocation(GitHubLocation var1);
    }
}

